/*
 Highmaps JS v10.3.3 (2023-01-20)

 Highmaps as a plugin for Highcharts or Highcharts Stock.

 (c) 2011-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(z){c(z);c.Highcharts=z;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function z(c,k,p,l){c.hasOwnProperty(k)||(c[k]=l.apply(null,p),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:k,module:c[k]}})))}c=c?c._modules:{};z(c,"Core/Axis/Color/ColorAxisComposition.js",
[c["Core/Color/Color.js"],c["Core/Utilities.js"]],function(c,k){var p=c.parse,l=k.addEvent,n=k.extend,h=k.merge,d=k.pick,D=k.splat,r;(function(g){function r(){var f=this,a=this.options;this.colorAxis=[];a.colorAxis&&(a.colorAxis=D(a.colorAxis),a.colorAxis.forEach(function(a,b){a.index=b;new x(f,a)}))}function b(f){var a=this,b=function(b){b=f.allItems.indexOf(b);-1!==b&&(a.destroyItem(f.allItems[b]),f.allItems.splice(b,1))},u=[],w,e;(this.chart.colorAxis||[]).forEach(function(f){(w=f.options)&&w.showInLegend&&
(w.dataClasses&&w.visible?u=u.concat(f.getDataClassLegendSymbols()):w.visible&&u.push(f),f.series.forEach(function(f){if(!f.options.showInLegend||w.dataClasses)"point"===f.options.legendType?f.points.forEach(function(f){b(f)}):b(f)}))});for(e=u.length;e--;)f.allItems.unshift(u[e])}function a(f){f.visible&&f.item.legendColor&&f.item.legendItem.symbol.attr({fill:f.item.legendColor})}function e(){var f=this.chart.colorAxis;f&&f.forEach(function(f,a,b){f.update({},b)})}function q(){(this.chart.colorAxis&&
this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function t(){var f=this.axisTypes;f?-1===f.indexOf("colorAxis")&&f.push("colorAxis"):this.axisTypes=["colorAxis"]}function m(f){var a=this,b=f?"show":"hide";a.visible=a.options.visible=!!f;["graphic","dataLabel"].forEach(function(f){if(a[f])a[f][b]()});this.series.buildKDTree()}function B(){var f=this,a=this.options.nullColor,b=this.colorAxis,u=this.colorKey;(this.data.length?this.data:this.points).forEach(function(w){var e=w.getNestedProperty(u);
(e=w.options.color||(w.isNull||null===w.value?a:b&&"undefined"!==typeof e?b.toColor(e,w):w.color||f.color))&&w.color!==e&&(w.color=e,"point"===f.options.legendType&&w.legendItem&&w.legendItem.label&&f.chart.legend.colorizeItem(w,w.visible))})}function u(f){var a=f.prototype.createAxis;f.prototype.createAxis=function(f,b){if("colorAxis"!==f)return a.apply(this,arguments);var u=new x(this,h(b.axis,{index:this[f].length,isX:!1}));this.isDirtyLegend=!0;this.axes.forEach(function(f){f.series=[]});this.series.forEach(function(f){f.bindAxes();
f.isDirtyData=!0});d(b.redraw,!0)&&this.redraw(b.animation);return u}}function f(){this.elem.attr("fill",p(this.start).tweenTo(p(this.end),this.pos),void 0,!0)}function A(){this.elem.attr("stroke",p(this.start).tweenTo(p(this.end),this.pos),void 0,!0)}var C=[],x;g.compose=function(g,d,h,v,w){x||(x=g);-1===C.indexOf(d)&&(C.push(d),g=d.prototype,g.collectionsWithUpdate.push("colorAxis"),g.collectionsWithInit.colorAxis=[g.addColorAxis],l(d,"afterGetAxes",r),u(d));-1===C.indexOf(h)&&(C.push(h),d=h.prototype,
d.fillSetter=f,d.strokeSetter=A);-1===C.indexOf(v)&&(C.push(v),l(v,"afterGetAllItems",b),l(v,"afterColorizeItem",a),l(v,"afterUpdate",e));-1===C.indexOf(w)&&(C.push(w),n(w.prototype,{optionalAxis:"colorAxis",translateColors:B}),n(w.prototype.pointClass.prototype,{setVisible:m}),l(w,"afterTranslate",q,{order:1}),l(w,"bindAxes",t))};g.pointSetVisible=m})(r||(r={}));return r});z(c,"Core/Axis/Color/ColorAxisDefaults.js",[],function(){return{lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,
startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{overflow:"justify",rotation:0},minColor:"#e6ebf5",maxColor:"#003399",tickLength:5,showInLegend:!0}});z(c,"Core/Axis/Color/ColorAxis.js",[c["Core/Axis/Axis.js"],c["Core/Color/Color.js"],c["Core/Axis/Color/ColorAxisComposition.js"],c["Core/Axis/Color/ColorAxisDefaults.js"],c["Core/Globals.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,
p,l,n,h,d,y){var r=this&&this.__extends||function(){var a=function(b,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,f){a.__proto__=f}||function(a,f){for(var b in f)Object.prototype.hasOwnProperty.call(f,b)&&(a[b]=f[b])};return a(b,e)};return function(b,e){function u(){this.constructor=b}if("function"!==typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");a(b,e);b.prototype=null===e?Object.create(e):(u.prototype=e.prototype,
new u)}}(),g=k.parse,v=d.series,b=y.extend,a=y.isNumber,e=y.merge,q=y.pick;k=function(t){function m(b,a){var f=t.call(this,b,a)||this;f.beforePadding=!1;f.chart=void 0;f.coll="colorAxis";f.dataClasses=void 0;f.name="";f.options=void 0;f.stops=void 0;f.visible=!0;f.init(b,a);return f}r(m,t);m.compose=function(b,a,f,e){p.compose(m,b,a,f,e)};m.prototype.init=function(b,a){var f=b.options.legend||{},u=a.layout?"vertical"!==a.layout:"vertical"!==f.layout,q=a.visible;f=e(m.defaultColorAxisOptions,a,{showEmpty:!1,
title:null,visible:f.enabled&&!1!==q});this.coll="colorAxis";this.side=a.side||u?2:1;this.reversed=a.reversed||!u;this.opposite=!u;t.prototype.init.call(this,b,f);this.userOptions.visible=q;a.dataClasses&&this.initDataClasses(a);this.initStops();this.horiz=u;this.zoomEnabled=!1};m.prototype.initDataClasses=function(a){var b=this.chart,f=this.legendItem=this.legendItem||{},A=a.dataClasses.length,q=this.options,m,t=0,B=b.options.chart.colorCount;this.dataClasses=m=[];f.labels=[];(a.dataClasses||[]).forEach(function(f,
a){f=e(f);m.push(f);if(b.styledMode||!f.color)"category"===q.dataClassColor?(b.styledMode||(a=b.options.colors,B=a.length,f.color=a[t]),f.colorIndex=t,t++,t===B&&(t=0)):f.color=g(q.minColor).tweenTo(g(q.maxColor),2>A?.5:a/(A-1))})};m.prototype.hasData=function(){return!!(this.tickPositions||[]).length};m.prototype.setTickPositions=function(){if(!this.dataClasses)return t.prototype.setTickPositions.call(this)};m.prototype.initStops=function(){this.stops=this.options.stops||[[0,this.options.minColor],
[1,this.options.maxColor]];this.stops.forEach(function(a){a.color=g(a[1])})};m.prototype.setOptions=function(a){t.prototype.setOptions.call(this,a);this.options.crosshair=this.options.marker};m.prototype.setAxisSize=function(){var a=this.legendItem&&this.legendItem.symbol,b=this.chart,f=b.options.legend||{},e,q;a?(this.left=f=a.attr("x"),this.top=e=a.attr("y"),this.width=q=a.attr("width"),this.height=a=a.attr("height"),this.right=b.chartWidth-f-q,this.bottom=b.chartHeight-e-a,this.len=this.horiz?
q:a,this.pos=this.horiz?f:e):this.len=(this.horiz?f.symbolWidth:f.symbolHeight)||m.defaultLegendLength};m.prototype.normalizedValue=function(a){this.logarithmic&&(a=this.logarithmic.log2lin(a));return 1-(this.max-a)/(this.max-this.min||1)};m.prototype.toColor=function(a,b){var f=this.dataClasses,e=this.stops,u;if(f)for(u=f.length;u--;){var q=f[u];var m=q.from;e=q.to;if(("undefined"===typeof m||a>=m)&&("undefined"===typeof e||a<=e)){var t=q.color;b&&(b.dataClass=u,b.colorIndex=q.colorIndex);break}}else{a=
this.normalizedValue(a);for(u=e.length;u--&&!(a>e[u][0]););m=e[u]||e[u+1];e=e[u+1]||m;a=1-(e[0]-a)/(e[0]-m[0]||1);t=m.color.tweenTo(e.color,a)}return t};m.prototype.getOffset=function(){var a=this.legendItem&&this.legendItem.group,b=this.chart.axisOffset[this.side];if(a){this.axisParent=a;t.prototype.getOffset.call(this);var f=this.chart.legend;f.allItems.forEach(function(a){a instanceof m&&a.drawLegendSymbol(f,a)});f.render();this.chart.getMargins(!0);this.added||(this.added=!0,this.labelLeft=0,
this.labelRight=this.width);this.chart.axisOffset[this.side]=b}};m.prototype.setLegendColor=function(){var a=this.reversed,b=a?1:0;a=a?0:1;b=this.horiz?[b,0,a,0]:[0,a,0,b];this.legendColor={linearGradient:{x1:b[0],y1:b[1],x2:b[2],y2:b[3]},stops:this.stops}};m.prototype.drawLegendSymbol=function(a,b){b=b.legendItem||{};var f=a.padding,e=a.options,u=q(e.itemDistance,10),t=this.horiz,g=q(e.symbolWidth,t?m.defaultLegendLength:12),d=q(e.symbolHeight,t?12:m.defaultLegendLength);e=q(e.labelPadding,t?16:
30);this.setLegendColor();b.symbol||(b.symbol=this.chart.renderer.rect(0,a.baseline-11,g,d).attr({zIndex:1}).add(b.group));b.labelWidth=g+f+(t?u:this.options.labels.x+this.maxLabelLength);b.labelHeight=d+f+(t?e:0)};m.prototype.setState=function(a){this.series.forEach(function(b){b.setState(a)})};m.prototype.setVisible=function(){};m.prototype.getSeriesExtremes=function(){var a=this.series,b=a.length,f;this.dataMin=Infinity;for(this.dataMax=-Infinity;b--;){var e=a[b];var m=e.colorKey=q(e.options.colorKey,
e.colorKey,e.pointValKey,e.zoneAxis,"y");var t=e.pointArrayMap;var g=e[m+"Min"]&&e[m+"Max"];if(e[m+"Data"])var d=e[m+"Data"];else if(t){d=[];t=t.indexOf(m);var h=e.yData;if(0<=t&&h)for(f=0;f<h.length;f++)d.push(q(h[f][t],h[f]))}else d=e.yData;g?(e.minColorValue=e[m+"Min"],e.maxColorValue=e[m+"Max"]):(d=v.prototype.getExtremes.call(e,d),e.minColorValue=d.dataMin,e.maxColorValue=d.dataMax);"undefined"!==typeof e.minColorValue&&(this.dataMin=Math.min(this.dataMin,e.minColorValue),this.dataMax=Math.max(this.dataMax,
e.maxColorValue));g||v.prototype.applyExtremes.call(e)}};m.prototype.drawCrosshair=function(a,b){var f=this.legendItem||{},e=b&&b.plotX,q=b&&b.plotY,m=this.pos,u=this.len;if(b){var g=this.toPixels(b.getNestedProperty(b.series.colorKey));g<m?g=m-2:g>m+u&&(g=m+u+2);b.plotX=g;b.plotY=this.len-g;t.prototype.drawCrosshair.call(this,a,b);b.plotX=e;b.plotY=q;this.cross&&!this.cross.addedToColorAxis&&f.group&&(this.cross.addClass("highcharts-coloraxis-marker").add(f.group),this.cross.addedToColorAxis=!0,
this.chart.styledMode||"object"!==typeof this.crosshair||this.cross.attr({fill:this.crosshair.color}))}};m.prototype.getPlotLinePath=function(b){var e=this.left,f=b.translatedValue,q=this.top;return a(f)?this.horiz?[["M",f-4,q-6],["L",f+4,q-6],["L",f,q],["Z"]]:[["M",e,f],["L",e-6,f+6],["L",e-6,f-6],["Z"]]:t.prototype.getPlotLinePath.call(this,b)};m.prototype.update=function(a,b){var f=this.chart.legend;this.series.forEach(function(a){a.isDirtyData=!0});(a.dataClasses&&f.allItems||this.dataClasses)&&
this.destroyItems();t.prototype.update.call(this,a,b);this.legendItem&&this.legendItem.label&&(this.setLegendColor(),f.colorizeItem(this,!0))};m.prototype.destroyItems=function(){var a=this.chart,b=this.legendItem||{};if(b.label)a.legend.destroyItem(this);else if(b.labels){var f=0;for(b=b.labels;f<b.length;f++)a.legend.destroyItem(b[f])}a.isDirtyLegend=!0};m.prototype.destroy=function(){this.chart.isDirtyLegend=!0;this.destroyItems();t.prototype.destroy.apply(this,[].slice.call(arguments))};m.prototype.remove=
function(a){this.destroyItems();t.prototype.remove.call(this,a)};m.prototype.getDataClassLegendSymbols=function(){var a=this,e=a.chart,f=a.legendItem&&a.legendItem.labels||[],m=e.options.legend,t=q(m.valueDecimals,-1),g=q(m.valueSuffix,""),d=function(b){return a.series.reduce(function(a,f){a.push.apply(a,f.points.filter(function(a){return a.dataClass===b}));return a},[])},r;f.length||a.dataClasses.forEach(function(q,m){var w=q.from,u=q.to,A=e.numberFormatter,H=!0;r="";"undefined"===typeof w?r="< ":
"undefined"===typeof u&&(r="> ");"undefined"!==typeof w&&(r+=A(w,t)+g);"undefined"!==typeof w&&"undefined"!==typeof u&&(r+=" - ");"undefined"!==typeof u&&(r+=A(u,t)+g);f.push(b({chart:e,name:r,options:{},drawLegendSymbol:h.drawRectangle,visible:!0,isDataClass:!0,setState:function(a){for(var b=0,f=d(m);b<f.length;b++)f[b].setState(a)},setVisible:function(){this.visible=H=a.visible=!H;for(var b=0,f=d(m);b<f.length;b++)f[b].setVisible(H);e.legend.colorizeItem(this,H)}},q))});return f};m.defaultColorAxisOptions=
l;m.defaultLegendLength=200;m.keepProps=["legendItem"];return m}(c);Array.prototype.push.apply(c.keepProps,k.keepProps);"";return k});z(c,"Maps/MapNavigationDefaults.js",[c["Core/Defaults.js"],c["Core/Utilities.js"]],function(c,k){k=k.extend;var p={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{fontSize:"15px",fontWeight:"bold"},theme:{"stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",
y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};k(c.defaultOptions.lang,{zoomIn:"Zoom in",zoomOut:"Zoom out"});return c.defaultOptions.mapNavigation=p});z(c,"Maps/MapNavigation.js",[c["Core/Chart/Chart.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,k,p){function l(a){a&&(a.preventDefault&&a.preventDefault(),a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)}function n(a){this.navButtons=[];this.init(a)}var h=k.doc,d=p.addEvent,y=p.extend,
r=p.isNumber,g=p.merge,v=p.objectEach,b=p.pick;n.prototype.init=function(a){this.chart=a};n.prototype.update=function(a){var e=this,q=this.chart,t=q.options.mapNavigation,m,h=function(a){this.handler.call(q,a);l(a)},u=e.navButtons;a&&(t=q.options.mapNavigation=g(q.options.mapNavigation,a));for(;u.length;)u.pop().destroy();b(t.enableButtons,t.enabled)&&!q.renderer.forExport&&(e.navButtonsGroup||(e.navButtonsGroup=q.renderer.g().attr({zIndex:4}).add()),v(t.buttons,function(a,b){a=g(t.buttonOptions,
a);!q.styledMode&&a.theme&&(m=a.theme,m.style=g(a.theme.style,a.style));var f=q.renderer.button(a.text||"",0,0,h,m,void 0,void 0,void 0,"zoomIn"===b?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+{zoomIn:"zoom-in",zoomOut:"zoom-out"}[b]).attr({width:a.width,height:a.height,title:q.options.lang[b],padding:a.padding,zIndex:5}).add(e.navButtonsGroup);f.handler=a.onclick;d(f.element,"dblclick",l);u.push(f);y(a,{width:f.width,height:2*f.height});if(q.hasLoaded)f.align(a,!1,
a.alignTo);else var A=d(q,"load",function(){f.element&&f.align(a,!1,a.alignTo);A()})}),a=function(){var a=q.exportingGroup&&q.exportingGroup.getBBox();if(a){var b=e.navButtonsGroup.getBBox();if(!(b.x>=a.x+a.width||b.x+b.width<=a.x||b.y>=a.y+a.height||b.y+b.height<=a.y)){var m=-b.y-b.height+a.y-5;a=a.y+a.height-b.y+5;e.navButtonsGroup.attr({translateY:"bottom"===(t.buttonOptions&&t.buttonOptions.verticalAlign)?m:a})}}},q.hasLoaded||d(q,"render",a));this.updateEvents(t)};n.prototype.updateEvents=function(a){var e=
this.chart;b(a.enableDoubleClickZoom,a.enabled)||a.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||d(e.container,"dblclick",function(a){e.pointer.onContainerDblClick(a)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());b(a.enableMouseWheelZoom,a.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||d(e.container,void 0!==h.onwheel?"wheel":void 0!==h.onmousewheel?"mousewheel":"DOMMouseScroll",function(a){e.pointer.inClass(a.target,"highcharts-no-mousewheel")||(e.pointer.onContainerMouseWheel(a),
l(a));return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};y(c.prototype,{fitToBox:function(a,b){[["x","width"],["y","height"]].forEach(function(e){var t=e[0];e=e[1];a[t]+a[e]>b[t]+b[e]&&(a[e]>b[e]?(a[e]=b[e],a[t]=b[t]):a[t]=b[t]+b[e]-a[e]);a[e]>b[e]&&(a[e]=b[e]);a[t]<b[t]&&(a[t]=b[t])});return a},mapZoom:function(a,b,q,t,m){this.mapView&&(r(a)&&(a=Math.log(a)/Math.log(.5)),this.mapView.zoomBy(a,r(b)&&r(q)?this.mapView.projection.inverse([b,q]):void 0,r(t)&&r(m)?[t,m]:
void 0))}});d(c,"beforeRender",function(){this.mapNavigation=new n(this);this.mapNavigation.update()});k.MapNavigation=n});z(c,"Maps/MapPointer.js",[c["Core/Pointer.js"],c["Core/Utilities.js"]],function(c,k){var p=k.defined,l=k.extend,n=k.pick;k=k.wrap;var h=c.prototype.normalize,d=0,y;l(c.prototype,{normalize:function(d,g){var r=this.chart;d=h.call(this,d,g);r&&r.mapView&&(g=r.mapView.pixelsToLonLat({x:d.chartX-r.plotLeft,y:d.chartY-r.plotTop}))&&l(d,g);return d},onContainerDblClick:function(d){var g=
this.chart;d=this.normalize(d);g.options.mapNavigation.enableDoubleClickZoomTo?g.pointer.inClass(d.target,"highcharts-tracker")&&g.hoverPoint&&g.hoverPoint.zoomTo():g.isInsidePlot(d.chartX-g.plotLeft,d.chartY-g.plotTop)&&g.mapZoom(.5,void 0,void 0,d.chartX,d.chartY)},onContainerMouseWheel:function(h){var g=this.chart;h=this.normalize(h);var c=p(h.wheelDelta)&&-h.wheelDelta/120||h.deltaY||h.detail;1<=Math.abs(c)&&(d+=Math.abs(c),y&&clearTimeout(y),y=setTimeout(function(){d=0},50));10>d&&g.isInsidePlot(h.chartX-
g.plotLeft,h.chartY-g.plotTop)&&g.mapView&&g.mapView.zoomBy((g.options.mapNavigation.mouseWheelSensitivity-1)*-c,void 0,[h.chartX,h.chartY],1>Math.abs(c)?!1:void 0)}});k(c.prototype,"zoomOption",function(d){var g=this.chart.options.mapNavigation;n(g.enableTouchZoom,g.enabled)&&(this.chart.options.chart.zooming.pinchType="xy");d.apply(this,[].slice.call(arguments,1))});k(c.prototype,"pinchTranslate",function(d,g,h,b,a,e,q){d.call(this,g,h,b,a,e,q);"map"===this.chart.options.chart.type&&this.hasZoom&&
(d=b.scaleX>b.scaleY,this.pinchTranslateDirection(!d,g,h,b,a,e,q,d?b.scaleX:b.scaleY))})});z(c,"Series/ColorMapComposition.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k){var p=c.seriesTypes.column.prototype,l=k.addEvent,n=k.defined,h;(function(d){function h(d){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:d&&"hover"===d.state?1:0})}var c=[];d.pointMembers={dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return null!==this.value&&Infinity!==
this.value&&-Infinity!==this.value&&(void 0===this.value||!isNaN(this.value))}};d.seriesMembers={colorKey:"value",axisTypes:["xAxis","yAxis","colorAxis"],parallelArrays:["x","y","value"],pointArrayMap:["value"],trackerGroups:["group","markerGroup","dataLabelsGroup"],colorAttribs:function(d){var g={};!n(d.color)||d.state&&"normal"!==d.state||(g[this.colorProp||"fill"]=d.color);return g},pointAttribs:p.pointAttribs};d.compose=function(d){var g=d.prototype.pointClass;-1===c.indexOf(g)&&(c.push(g),l(g,
"afterSetState",h));return d}})(h||(h={}));return h});z(c,"Maps/MapSymbols.js",[c["Core/Renderer/SVG/SVGRenderer.js"]],function(c){function k(c,l,n,h,d,k,r,g){return[["M",c+d,l],["L",c+n-k,l],["C",c+n-k/2,l,c+n,l+k/2,c+n,l+k],["L",c+n,l+h-r],["C",c+n,l+h-r/2,c+n-r/2,l+h,c+n-r,l+h],["L",c+g,l+h],["C",c+g/2,l+h,c,l+h-g/2,c,l+h-g],["L",c,l+d],["C",c,l+d/2,c+d/2,l,c+d,l],["Z"]]}c=c.prototype.symbols;c.bottombutton=function(c,l,n,h,d){d=d&&d.r||0;return k(c-1,l-1,n,h,0,0,d,d)};c.topbutton=function(c,l,
n,h,d){d=d&&d.r||0;return k(c-1,l-1,n,h,d,d,0,0)};return c});z(c,"Core/Chart/MapChart.js",[c["Core/Chart/Chart.js"],c["Core/Defaults.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,k,p,l){var n=this&&this.__extends||function(){var d=function(g,c){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var e in a)Object.prototype.hasOwnProperty.call(a,e)&&(b[e]=a[e])};return d(g,c)};return function(g,c){function b(){this.constructor=
g}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");d(g,c);g.prototype=null===c?Object.create(c):(b.prototype=c.prototype,new b)}}(),h=k.getOptions,d=l.merge,y=l.pick;c=function(c){function g(){return null!==c&&c.apply(this,arguments)||this}n(g,c);g.prototype.init=function(g,b){var a=h().credits;g=d({chart:{panning:{enabled:!0,type:"xy"},type:"map"},credits:{mapText:y(a.mapText,' \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),
mapTextFull:y(a.mapTextFull,"{geojson.copyright}")},mapView:{},tooltip:{followTouchMove:!1}},g);c.prototype.init.call(this,g,b)};return g}(c);(function(d){d.maps={};d.mapChart=function(c,h,b){return new d(c,h,b)};d.splitPath=function(d){"string"===typeof d&&(d=d.replace(/([A-Za-z])/g," $1 ").replace(/^\s*/,"").replace(/\s*$/,""),d=d.split(/[ ,;]+/).map(function(d){return/[A-za-z]/.test(d)?d:parseFloat(d)}));return p.prototype.pathToSegments(d)}})(c||(c={}));return c});z(c,"Maps/MapUtilities.js",[],
function(){return{boundsFromPath:function(c){var k=-Number.MAX_VALUE,p=Number.MAX_VALUE,l=-Number.MAX_VALUE,n=Number.MAX_VALUE,h;c.forEach(function(d){var c=d[d.length-2];d=d[d.length-1];"number"===typeof c&&"number"===typeof d&&(p=Math.min(p,c),k=Math.max(k,c),n=Math.min(n,d),l=Math.max(l,d),h=!0)});if(h)return{x1:p,y1:n,x2:k,y2:l}},pointInPolygon:function(c,k){var p,l=!1,n=c.x,h=c.y;c=0;for(p=k.length-1;c<k.length;p=c++){var d=k[c][1]>h;var y=k[p][1]>h;d!==y&&n<(k[p][0]-k[c][0])*(h-k[c][1])/(k[p][1]-
k[c][1])+k[c][0]&&(l=!l)}return l}}});z(c,"Series/Map/MapPoint.js",[c["Series/ColorMapComposition.js"],c["Maps/MapUtilities.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,p,l){var n=this&&this.__extends||function(){var d=function(c,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var e in b)Object.prototype.hasOwnProperty.call(b,e)&&(a[e]=b[e])};return d(c,b)};return function(c,b){function a(){this.constructor=
c}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");d(c,b);c.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),h=k.boundsFromPath,d=l.extend,y=l.isNumber,r=l.pick;k=function(c){function g(){var b=null!==c&&c.apply(this,arguments)||this;b.options=void 0;b.path=void 0;b.series=void 0;return b}n(g,c);g.getProjectedPath=function(b,a){b.projectedPath||(a&&b.geometry?(a.hasCoordinates=!0,b.projectedPath=a.path(b.geometry)):
b.projectedPath=b.path);return b.projectedPath||[]};g.prototype.applyOptions=function(b,a){var e=this.series;b=c.prototype.applyOptions.call(this,b,a);a=e.joinBy;e.mapData&&e.mapMap&&(a=c.prototype.getNestedProperty.call(b,a[1]),(a="undefined"!==typeof a&&e.mapMap[a])?d(b,a):-1!==e.pointArrayMap.indexOf("value")&&(b.value=b.value||null));return b};g.prototype.getProjectedBounds=function(b){b=g.getProjectedPath(this,b);b=h(b);var a=this.properties;if(b){var e=a&&a["hc-middle-x"];a=a&&a["hc-middle-y"];
b.midX=b.x1+(b.x2-b.x1)*r(this.middleX,y(e)?e:.5);e=r(this.middleY,y(a)?a:.5);this.geometry||(e=1-e);b.midY=b.y2-(b.y2-b.y1)*e;return b}};g.prototype.onMouseOver=function(b){l.clearTimeout(this.colorInterval);if(!this.isNull&&this.visible||this.series.options.nullInteraction)c.prototype.onMouseOver.call(this,b);else this.series.onMouseOut(b)};g.prototype.setVisible=function(b){var a=b?"show":"hide";this.visible=this.options.visible=!!b;if(this.dataLabel)this.dataLabel[a]();this.graphic&&this.graphic.attr(this.series.pointAttribs(this))};
g.prototype.zoomTo=function(){var b=this.series.chart,a=b.mapView,e=this.bounds;if(a&&e){var c=y(this.insetIndex)&&a.insets[this.insetIndex];if(c){var d=c.projectedUnitsToPixels({x:e.x1,y:e.y1});e=c.projectedUnitsToPixels({x:e.x2,y:e.y2});d=a.pixelsToProjectedUnits({x:d.x,y:d.y});e=a.pixelsToProjectedUnits({x:e.x,y:e.y});e={x1:d.x,y1:d.y,x2:e.x,y2:e.y}}a.fitToBounds(e,void 0,!1);this.series.isDirty=!0;b.redraw()}};return g}(p.seriesTypes.scatter.prototype.pointClass);d(k.prototype,{dataLabelOnNull:c.pointMembers.dataLabelOnNull,
moveToTopOnHover:c.pointMembers.moveToTopOnHover,isValid:c.pointMembers.isValid});return k});z(c,"Maps/MapViewOptionsDefault.js",[],function(){return{center:[0,0],fitToGeometry:void 0,maxZoom:void 0,padding:0,projection:{name:void 0,parallels:void 0,rotation:void 0},zoom:void 0}});z(c,"Maps/MapViewInsetsOptionsDefault.js",[],function(){return{borderColor:"#cccccc",borderWidth:1,center:[0,0],padding:"10%",relativeTo:"mapBoundingBox",units:"percent"}});z(c,"Extensions/GeoJSON.js",[c["Core/Chart/Chart.js"],
c["Core/FormatUtilities.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,k,p,l){function n(b,a){a||(a=Object.keys(b.objects)[0]);a=b.objects[a];if(a["hc-decoded-geojson"])return a["hc-decoded-geojson"];var e=b.arcs;if(b.transform){var c=b.transform,d=c.scale,m=c.translate;e=b.arcs.map(function(a){var b=0,e=0;return a.map(function(a){a=a.slice();a[0]=(b+=a[0])*d[0]+m[0];a[1]=(e+=a[1])*d[1]+m[1];return a})})}var g=function(a){return"number"===typeof a[0]?a.reduce(function(a,b,c){var f=0>
b?e[~b]:e[b];0>b?(f=f.slice(0,0===c?f.length:f.length-1),f.reverse()):c&&(f=f.slice(1));return a.concat(f)},[]):a.map(g)};c=a.geometries.map(function(a){return{type:"Feature",properties:a.properties,geometry:{type:a.type,coordinates:a.coordinates||g(a.arcs)}}});b={type:"FeatureCollection",copyright:b.copyright,copyrightShort:b.copyrightShort,copyrightUrl:b.copyrightUrl,features:c,"hc-recommended-mapview":a["hc-recommended-mapview"],bbox:b.bbox,title:b.title};return a["hc-decoded-geojson"]=b}function h(b,
a,e){void 0===a&&(a="map");var c=[];b="Topology"===b.type?n(b):b;b.features.forEach(function(b){var e=b.geometry||{},d=e.type;e=e.coordinates;b=b.properties;var q;"map"!==a&&"mapbubble"!==a||"Polygon"!==d&&"MultiPolygon"!==d?"mapline"!==a||"LineString"!==d&&"MultiLineString"!==d?"mappoint"===a&&"Point"===d&&e.length&&(q={geometry:{coordinates:e,type:d}}):e.length&&(q={geometry:{coordinates:e,type:d}}):e.length&&(q={geometry:{coordinates:e,type:d}});if(q){d=b&&(b.name||b.NAME);e=b&&b.lon;var f=b&&
b.lat;c.push(g(q,{lat:"number"===typeof f?f:void 0,lon:"number"===typeof e?e:void 0,name:"string"===typeof d?d:void 0,properties:b}))}});e&&b.copyrightShort&&(e.chart.mapCredits=d(e.chart.options.credits.mapText,{geojson:b}),e.chart.mapCreditsFull=d(e.chart.options.credits.mapTextFull,{geojson:b}));return c}var d=k.format,y=p.win,r=l.error,g=l.extend,v=l.merge;k=l.wrap;"";c.prototype.transformFromLatLon=function(b,a){var e=this.options.chart.proj4||y.proj4;if(e){var c=a.jsonmarginX;c=void 0===c?0:
c;var d=a.jsonmarginY;d=void 0===d?0:d;var m=a.jsonres;m=void 0===m?1:m;var g=a.scale;g=void 0===g?1:g;var u=a.xoffset;u=void 0===u?0:u;var f=a.xpan;f=void 0===f?0:f;var h=a.yoffset;h=void 0===h?0:h;var n=a.ypan;n=void 0===n?0:n;b=e(a.crs,[b.lon,b.lat]);e=a.cosAngle||a.rotation&&Math.cos(a.rotation);var l=a.sinAngle||a.rotation&&Math.sin(a.rotation);a=a.rotation?[b[0]*e+b[1]*l,-b[0]*l+b[1]*e]:b;return{x:((a[0]-u)*g+f)*m+c,y:-(((h-a[1])*g+n)*m-d)}}r(21,!1,this)};c.prototype.transformToLatLon=function(b,
a){var e=this.options.chart.proj4||y.proj4;if(!e)r(21,!1,this);else if(null!==b.y){var c=a.jsonmarginX,d=a.jsonmarginY,m=a.jsonres;m=void 0===m?1:m;var g=a.scale;g=void 0===g?1:g;var h=a.xoffset,f=a.xpan,n=a.yoffset,l=a.ypan;b={x:((b.x-(void 0===c?0:c))/m-(void 0===f?0:f))/g+(void 0===h?0:h),y:((b.y-(void 0===d?0:d))/m+(void 0===l?0:l))/g+(void 0===n?0:n)};c=a.cosAngle||a.rotation&&Math.cos(a.rotation);d=a.sinAngle||a.rotation&&Math.sin(a.rotation);a=e(a.crs,"WGS84",a.rotation?{x:b.x*c+b.y*-d,y:b.x*
d+b.y*c}:b);return{lat:a.y,lon:a.x}}};c.prototype.fromPointToLatLon=function(b){return this.mapView&&this.mapView.projectedUnitsToLonLat(b)};c.prototype.fromLatLonToPoint=function(b){return this.mapView&&this.mapView.lonLatToProjectedUnits(b)};k(c.prototype,"addCredits",function(b,a){a=v(!0,this.options.credits,a);this.mapCredits&&(a.href=null);b.call(this,a);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})});p.geojson=h;p.topo2geo=n;return{geojson:h,topo2geo:n}});
z(c,"Core/Geometry/PolygonClip.js",[],function(){var c=function(c,n,h){return(n[0]-c[0])*(h[1]-c[1])>(n[1]-c[1])*(h[0]-c[0])},k=function(c,n,h,d){var l=[c[0]-n[0],c[1]-n[1]],k=[h[0]-d[0],h[1]-d[1]];c=c[0]*n[1]-c[1]*n[0];h=h[0]*d[1]-h[1]*d[0];d=1/(l[0]*k[1]-l[1]*k[0]);l=[(c*k[0]-h*l[0])*d,(c*k[1]-h*l[1])*d];l.isIntersection=!0;return l},p;(function(l){l.clipLineString=function(c,h){var d=[];c=l.clipPolygon(c,h,!1);for(h=1;h<c.length;h++)c[h].isIntersection&&c[h-1].isIntersection&&(d.push(c.splice(0,
h)),h=0),h===c.length-1&&d.push(c);return d};l.clipPolygon=function(n,h,d){void 0===d&&(d=!0);for(var l=h[h.length-1],r,g,p=n,b=0;b<h.length;b++){var a=p;n=h[b];p=[];r=d?a[a.length-1]:a[0];for(var e=0;e<a.length;e++)g=a[e],c(l,n,g)?(c(l,n,r)||p.push(k(l,n,r,g)),p.push(g)):c(l,n,r)&&p.push(k(l,n,r,g)),r=g;l=n}return p}})(p||(p={}));return p});z(c,"Maps/Projections/LambertConformalConic.js",[],function(){var c=Math.sign||function(c){return 0===c?0:0<c?1:-1},k=Math.PI/180,p=Math.PI/2;return function(){function l(l){var h,
d=(l.parallels||[]).map(function(c){return c*k}),n=d[0]||0;d=null!==(h=d[1])&&void 0!==h?h:n;h=Math.cos(n);"object"===typeof l.projectedBounds&&(this.projectedBounds=l.projectedBounds);l=n===d?Math.sin(n):Math.log(h/Math.cos(d))/Math.log(Math.tan((p+d)/2)/Math.tan((p+n)/2));1e-10>Math.abs(l)&&(l=1e-10*(c(l)||1));this.n=l;this.c=h*Math.pow(Math.tan((p+n)/2),l)/l}l.prototype.forward=function(c){var h=c[0]*k,d=this.c,l=this.n,n=this.projectedBounds;c=c[1]*k;0<d?c<-p+.000001&&(c=-p+.000001):c>p-.000001&&
(c=p-.000001);var g=d/Math.pow(Math.tan((p+c)/2),l);c=g*Math.sin(l*h)*63.78137;h=63.78137*(d-g*Math.cos(l*h));d=[c,h];n&&(c<n.x1||c>n.x2||h<n.y1||h>n.y2)&&(d.outside=!0);return d};l.prototype.inverse=function(l){var h=l[0]/63.78137,d=this.c,n=this.n;l=d-l[1]/63.78137;var r=c(n)*Math.sqrt(h*h+l*l),g=Math.atan2(h,Math.abs(l))*c(l);0>l*n&&(g-=Math.PI*c(h)*c(l));return[g/n/k,(2*Math.atan(Math.pow(d/r,1/n))-p)/k]};return l}()});z(c,"Maps/Projections/EqualEarth.js",[],function(){var c=Math.sqrt(3)/2;return function(){function k(){this.bounds=
{x1:-200.37508342789243,x2:200.37508342789243,y1:-97.52595454902263,y2:97.52595454902263}}k.prototype.forward=function(k){var l=Math.PI/180,n=Math.asin(c*Math.sin(k[1]*l)),h=n*n,d=h*h*h;return[k[0]*l*Math.cos(n)*74.03120656864502/(c*(1.340264+3*-.081106*h+d*(7*.000893+.034164*h))),74.03120656864502*n*(1.340264+-.081106*h+d*(.000893+.003796*h))]};k.prototype.inverse=function(k){var l=k[0]/74.03120656864502;k=k[1]/74.03120656864502;var n=180/Math.PI,h=k,d;for(d=0;12>d;++d){var p=h*h;var r=p*p*p;var g=
h*(1.340264+-.081106*p+r*(.000893+.003796*p))-k;p=1.340264+3*-.081106*p+r*(7*.000893+.034164*p);h-=g/=p;if(1e-9>Math.abs(g))break}p=h*h;return[n*c*l*(1.340264+3*-.081106*p+p*p*p*(7*.000893+.034164*p))/Math.cos(h),n*Math.asin(Math.sin(h)/c)]};return k}()});z(c,"Maps/Projections/Miller.js",[],function(){var c=Math.PI/4,k=Math.PI/180;return function(){function p(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-146.91480769173063,y2:146.91480769173063}}p.prototype.forward=function(l){return[l[0]*
k*63.78137,79.7267125*Math.log(Math.tan(c+.4*l[1]*k))]};p.prototype.inverse=function(l){return[l[0]/63.78137/k,2.5*(Math.atan(Math.exp(l[1]/63.78137*.8))-c)/k]};return p}()});z(c,"Maps/Projections/Orthographic.js",[],function(){var c=Math.PI/180;return function(){function k(){this.antimeridianCutting=!1;this.bounds={x1:-63.78460826781007,x2:63.78460826781007,y1:-63.78460826781007,y2:63.78460826781007}}k.prototype.forward=function(k){var l=k[0];k=k[1]*c;k=[Math.cos(k)*Math.sin(l*c)*63.78460826781007,
63.78460826781007*Math.sin(k)];if(-90>l||90<l)k.outside=!0;return k};k.prototype.inverse=function(k){var l=k[0]/63.78460826781007;k=k[1]/63.78460826781007;var n=Math.sqrt(l*l+k*k),h=Math.asin(n),d=Math.sin(h);return[Math.atan2(l*d,n*Math.cos(h))/c,Math.asin(n&&k*d/n)/c]};return k}()});z(c,"Maps/Projections/WebMercator.js",[],function(){var c=Math.PI/180;return function(){function k(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-200.3750834278071,y2:200.3750834278071};this.maxLatitude=
85.0511287798}k.prototype.forward=function(k){var l=Math.sin(k[1]*c);l=[63.78137*k[0]*c,63.78137*Math.log((1+l)/(1-l))/2];85.0511287798<Math.abs(k[1])&&(l.outside=!0);return l};k.prototype.inverse=function(k){return[k[0]/(63.78137*c),(2*Math.atan(Math.exp(k[1]/63.78137))-Math.PI/2)/c]};return k}()});z(c,"Maps/Projections/ProjectionRegistry.js",[c["Maps/Projections/LambertConformalConic.js"],c["Maps/Projections/EqualEarth.js"],c["Maps/Projections/Miller.js"],c["Maps/Projections/Orthographic.js"],c["Maps/Projections/WebMercator.js"]],
function(c,k,p,l,n){return{EqualEarth:k,LambertConformalConic:c,Miller:p,Orthographic:l,WebMercator:n}});z(c,"Maps/Projection.js",[c["Core/Geometry/PolygonClip.js"],c["Maps/Projections/ProjectionRegistry.js"],c["Core/Utilities.js"]],function(c,k,p){var l=this&&this.__spreadArray||function(c,b,a){if(a||2===arguments.length)for(var e=0,d=b.length,g;e<d;e++)!g&&e in b||(g||(g=Array.prototype.slice.call(b,0,e)),g[e]=b[e]);return c.concat(g||Array.prototype.slice.call(b))},n=c.clipLineString,h=c.clipPolygon,
d=p.clamp,y=p.erase,r=2*Math.PI/360,g=function(c){-180>c&&(c+=360);180<c&&(c-=360);return c};return function(){function c(b){void 0===b&&(b={});this.hasGeoProjection=this.hasCoordinates=!1;this.maxLatitude=90;this.options=b;var a=b.name,e=b.projectedBounds,d=b.rotation;this.rotator=d?this.getRotator(d):void 0;if(a=a?c.registry[a]:void 0)this.def=new a(b);var g=this.def,m=this.rotator;g&&(this.maxLatitude=g.maxLatitude||90,this.hasGeoProjection=!0);m&&g?(this.forward=function(a){return g.forward(m.forward(a))},
this.inverse=function(a){return m.inverse(g.inverse(a))}):g?(this.forward=function(a){return g.forward(a)},this.inverse=function(a){return g.inverse(a)}):m&&(this.forward=m.forward,this.inverse=m.inverse);this.bounds="world"===e?g&&g.bounds:e}c.add=function(b,a){c.registry[b]=a};c.greatCircle=function(b,a,c){var e=Math.atan2,d=Math.cos,m=Math.sin,g=Math.sqrt,h=b[1]*r,f=b[0]*r,l=a[1]*r,k=a[0]*r,x=l-h,n=k-f;x=m(x/2)*m(x/2)+d(h)*d(l)*m(n/2)*m(n/2);x=2*e(g(x),g(1-x));var p=Math.round(6371E3*x/5E5);n=
[];c&&n.push(b);if(1<p)for(p=b=1/p;.999>p;p+=b){var v=m((1-p)*x)/m(x),F=m(p*x)/m(x),w=v*d(h)*d(f)+F*d(l)*d(k),I=v*d(h)*m(f)+F*d(l)*m(k);v=v*m(h)+F*m(l);v=e(v,g(w*w+I*I));w=e(I,w);n.push([w/r,v/r])}c&&n.push(a);return n};c.insertGreatCircles=function(b){for(var a=b.length-1;a--;)if(10<Math.max(Math.abs(b[a][0]-b[a+1][0]),Math.abs(b[a][1]-b[a+1][1]))){var e=c.greatCircle(b[a],b[a+1]);e.length&&b.splice.apply(b,l([a+1,0],e,!1))}};c.toString=function(b){b=b||{};var a=b.rotation;return[b.name,a&&a.join(",")].join(";")};
c.prototype.lineIntersectsBounds=function(b){var a=this.bounds||{},c=a.x2,d=a.y1,g=a.y2,m=function(a,b,c){var e=a[0];a=a[1];var f=b?0:1;if("number"===typeof c&&e[b]>=c!==a[b]>=c)return e=e[f]+(c-e[b])/(a[b]-e[b])*(a[f]-e[f]),b?[e,c]:[c,e]},h=b[0];if(a=m(b,0,a.x1))h=a,b[1]=a;else if(a=m(b,0,c))h=a,b[1]=a;if(a=m(b,1,d))h=a;else if(a=m(b,1,g))h=a;return h};c.prototype.getRotator=function(b){var a=b[0]*r,c=(b[1]||0)*r;b=(b[2]||0)*r;var d=Math.cos(c),g=Math.sin(c),m=Math.cos(b),h=Math.sin(b);if(0!==a||
0!==c||0!==b)return{forward:function(b){var c=b[0]*r+a,e=b[1]*r,q=Math.cos(e);b=Math.cos(c)*q;c=Math.sin(c)*q;e=Math.sin(e);q=e*d+b*g;return[Math.atan2(c*m-q*h,b*d-e*g)/r,Math.asin(q*m+c*h)/r]},inverse:function(b){var c=b[0]*r,e=b[1]*r,q=Math.cos(e);b=Math.cos(c)*q;c=Math.sin(c)*q;e=Math.sin(e);q=e*m-c*h;return[(Math.atan2(c*m+e*h,b*d+q*g)-a)/r,Math.asin(q*d-b*g)/r]}}};c.prototype.forward=function(b){return b};c.prototype.inverse=function(b){return b};c.prototype.cutOnAntimeridian=function(b,a){var e=
[],h=[b];b.forEach(function(c,f){var g=b[f-1];if(!f){if(!a)return;g=b[b.length-1]}var m=g[0],w=c[0];(-90>m||90<m)&&(-90>w||90<w)&&0<m!==0<w&&(w=d((180-(m+360)%360)/((w+360)%360-(m+360)%360),0,1),e.push({i:f,lat:g[1]+w*(c[1]-g[1]),direction:0>m?1:-1,previousLonLat:g,lonLat:c}))});if(e.length)if(a){if(1===e.length%2){var t=e.slice().sort(function(a,b){return Math.abs(b.lat)-Math.abs(a.lat)})[0];y(e,t)}for(var m=e.length-2;0<=m;){var k=e[m].i,u=g(180+.000001*e[m].direction),f=g(180-.000001*e[m].direction);
k=b.splice.apply(b,l([k,e[m+1].i-k],c.greatCircle([u,e[m].lat],[u,e[m+1].lat],!0),!1));k.push.apply(k,c.greatCircle([f,e[m+1].lat],[f,e[m].lat],!0));h.push(k);m-=2}if(t)for(u=0;u<h.length;u++){m=t.direction;var n=t.lat;f=h[u];k=f.indexOf(t.lonLat);if(-1<k){u=(0>n?-1:1)*this.maxLatitude;var p=g(180+.000001*m),x=g(180-.000001*m);n=c.greatCircle([p,n],[p,u],!0);for(p+=120*m;-180<p&&180>p;p+=120*m)n.push([p,u]);n.push.apply(n,c.greatCircle([x,u],[x,t.lat],!0));f.splice.apply(f,l([k,0],n,!1));break}}}else for(m=
e.length;m--;)k=e[m].i,k=b.splice(k,b.length,[g(180+.000001*e[m].direction),e[m].lat]),k.unshift([g(180-.000001*e[m].direction),e[m].lat]),h.push(k);return h};c.prototype.path=function(b){var a=this,e=this.bounds,d=this.def,g=this.rotator,m=[],l="Polygon"===b.type||"MultiPolygon"===b.type,k=this.hasGeoProjection,f=!d||!1!==d.antimeridianCutting,p=f?g:void 0,r=f?d||this:this,x;e&&(x=[[e.x1,e.y1],[e.x2,e.y1],[e.x2,e.y2],[e.x1,e.y2]]);var v=function(b){b=b.map(function(a){if(f){p&&(a=p.forward(a));var b=
a[0];.000001>Math.abs(b-180)&&(b=180>b?179.999999:180.000001);a=[b,a[1]]}return a});var d=[b];k&&(c.insertGreatCircles(b),f&&(d=a.cutOnAntimeridian(b,l)));d.forEach(function(a){if(!(2>a.length)){var b=!1,d=!1,g=function(a){b?m.push(["L",a[0],a[1]]):(m.push(["M",a[0],a[1]]),b=!0)},q=!1,J=!1,t=a.map(function(a){a=r.forward(a);a.outside?q=!0:J=!0;Infinity===a[1]?a[1]=1E10:-Infinity===a[1]&&(a[1]=-1E10);return a});if(f){l&&t.push(t[0]);if(q){if(!J)return;if(x)if(l)t=h(t,x);else if(e){n(t,x).forEach(function(a){b=
!1;a.forEach(g)});return}}t.forEach(g)}else for(var u=0;u<t.length;u++){var p=a[u],A=t[u];if(A.outside)d=!0;else{if(l&&!C){var C=p;a.push(p);t.push(A)}d&&v&&(l&&k?c.greatCircle(v,p).forEach(function(a){return g(r.forward(a))}):b=!1);g(A);var v=p;d=!1}}}})};"LineString"===b.type?v(b.coordinates):"MultiLineString"===b.type?b.coordinates.forEach(function(a){return v(a)}):"Polygon"===b.type?(b.coordinates.forEach(function(a){return v(a)}),m.length&&m.push(["Z"])):"MultiPolygon"===b.type&&(b.coordinates.forEach(function(a){a.forEach(function(a){return v(a)})}),
m.length&&m.push(["Z"]));return m};c.registry=k;return c}()});z(c,"Maps/MapView.js",[c["Maps/MapViewOptionsDefault.js"],c["Maps/MapViewInsetsOptionsDefault.js"],c["Extensions/GeoJSON.js"],c["Core/Chart/MapChart.js"],c["Maps/MapUtilities.js"],c["Maps/Projection.js"],c["Core/Utilities.js"]],function(c,k,p,l,n,h,d){var y=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,
c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),r=this&&this.__spreadArray||function(a,b,c){if(c||2===arguments.length)for(var e=0,f=b.length,d;e<f;e++)!d&&e in b||(d||(d=Array.prototype.slice.call(b,0,e)),d[e]=b[e]);return a.concat(d||Array.prototype.slice.call(b))},
g=p.topo2geo,v=l.maps,b=n.boundsFromPath,a=n.pointInPolygon,e=d.addEvent,q=d.clamp,t=d.fireEvent,m=d.isArray,B=d.isNumber,u=d.isObject,f=d.isString,A=d.merge,C=d.pick,x=d.relativeLength,G=function(a,b){return Math.log(400.979322/Math.max((a.x2-a.x1)/(b.width/256),(a.y2-a.y1)/(b.height/256)))/Math.log(2)},E=function(){function d(a,b){var f=this;this.insets=[];this.padding=[0,0,0,0];this.eventsToUnbind=[];var g;if(!(this instanceof D)){var m=r([a.options.chart.map],(a.options.series||[]).map(function(a){return a.mapData}),
!0).map(function(a){return f.getGeoMap(a)}),w=[];m.forEach(function(a){a&&(g||(g=a["hc-recommended-mapview"]),a.bbox&&(a=a.bbox,w.push({x1:a[0],y1:a[1],x2:a[2],y2:a[3]})))});var q=w.length&&d.compositeBounds(w);if(q){var l=q.x1;var k=q.y1,t=q.x2;q=q.y2;l=180<t-l&&90<q-k?{name:"EqualEarth"}:{name:"LambertConformalConic",parallels:[k,q],rotation:[-(l+t)/2]}}this.geoMap=m[0]}this.userOptions=b||{};m=A(c,{projection:l},g,b);q=g&&g.insets;b=b&&b.insets;q&&b&&(m.insets=d.mergeInsets(q,b));this.chart=a;
this.center=m.center;this.options=m;this.projection=new h(m.projection);this.playingField=a.plotBox;this.zoom=m.zoom||0;this.createInsets();this.eventsToUnbind.push(e(a,"afterSetChartSize",function(){f.playingField=f.getField();if(void 0===f.minZoom||f.minZoom===f.zoom)f.fitToBounds(void 0,void 0,!1),!f.chart.hasRendered&&B(f.userOptions.zoom)&&(f.zoom=f.userOptions.zoom),f.userOptions.center&&A(!0,f.center,f.userOptions.center)}));this.setUpEvents()}d.mergeInsets=function(a,b){var c=function(a){var b=
{};a.forEach(function(a,c){b[a&&a.id||"i".concat(c)]=a});return b},e=A(c(a),c(b));return Object.keys(e).map(function(a){return e[a]})};d.prototype.createInsets=function(){var a=this,b=this.options,c=b.insets;c&&c.forEach(function(c){c=new D(a,A(b.insetOptions,c));a.insets.push(c)})};d.prototype.fitToBounds=function(a,b,c,e){void 0===c&&(c=!0);var d=a||this.getProjectedBounds();if(d){var f=C(b,a?0:this.options.padding);b=this.getField(!1);f=m(f)?f:[f,f,f,f];this.padding=[x(f[0],b.height),x(f[1],b.width),
x(f[2],b.height),x(f[3],b.width)];this.playingField=this.getField();b=G(d,this.playingField);a||(this.minZoom=b);a=this.projection.inverse([(d.x2+d.x1)/2,(d.y2+d.y1)/2]);this.setView(a,b,c,e)}};d.prototype.getField=function(a){void 0===a&&(a=!0);a=a?this.padding:[0,0,0,0];return{x:a[3],y:a[0],width:this.chart.plotWidth-a[1]-a[3],height:this.chart.plotHeight-a[0]-a[2]}};d.prototype.getGeoMap=function(a){if(f(a))return v[a];if(u(a,!0)){if("FeatureCollection"===a.type)return a;if("Topology"===a.type)return g(a)}};
d.prototype.getMapBBox=function(){var a=this.getProjectedBounds(),b=this.getScale();if(a){var c=this.padding,e=this.projectedUnitsToPixels({x:a.x1,y:a.y2});return{width:(a.x2-a.x1)*b+c[1]+c[3],height:(a.y2-a.y1)*b+c[0]+c[2],x:e.x-c[3],y:e.y-c[0]}}};d.prototype.getProjectedBounds=function(){var a=this.projection,c=this.chart.series.reduce(function(a,b){var c=b.getProjectedBounds&&b.getProjectedBounds();c&&!1!==b.options.affectsMapView&&a.push(c);return a},[]),e=this.options.fitToGeometry;return e?
(this.fitToGeometryCache||("MultiPoint"===e.type?(e=e.coordinates.map(function(b){return a.forward(b)}),c=e.map(function(a){return a[0]}),e=e.map(function(a){return a[1]}),this.fitToGeometryCache={x1:Math.min.apply(0,c),x2:Math.max.apply(0,c),y1:Math.min.apply(0,e),y2:Math.max.apply(0,e)}):this.fitToGeometryCache=b(a.path(e))),this.fitToGeometryCache):this.projection.bounds||d.compositeBounds(c)};d.prototype.getScale=function(){return 256/400.979322*Math.pow(2,this.zoom)};d.prototype.getSVGTransform=
function(){var a=this.playingField,b=a.x,c=a.y,e=a.width;a=a.height;var d=this.projection.forward(this.center),f=this.projection.hasCoordinates?-1:1,g=this.getScale();f*=g;return{scaleX:g,scaleY:f,translateX:b+e/2-d[0]*g,translateY:c+a/2-d[1]*f}};d.prototype.lonLatToPixels=function(a){if(a=this.lonLatToProjectedUnits(a))return this.projectedUnitsToPixels(a)};d.prototype.lonLatToProjectedUnits=function(b){var c=this.chart,e=c.mapTransforms;if(e){for(var f in e)if(Object.hasOwnProperty.call(e,f)&&e[f].hitZone){var d=
c.transformFromLatLon(b,e[f]);if(d&&a(d,e[f].hitZone.coordinates[0]))return d}return c.transformFromLatLon(b,e["default"])}e=0;for(f=this.insets;e<f.length;e++)if(c=f[e],c.options.geoBounds&&a({x:b.lon,y:b.lat},c.options.geoBounds.coordinates[0]))return b=c.projection.forward([b.lon,b.lat]),b=c.projectedUnitsToPixels({x:b[0],y:b[1]}),this.pixelsToProjectedUnits(b);b=this.projection.forward([b.lon,b.lat]);if(!b.outside)return{x:b[0],y:b[1]}};d.prototype.projectedUnitsToLonLat=function(b){var c=this.chart,
e=c.mapTransforms;if(e){for(var f in e)if(Object.hasOwnProperty.call(e,f)&&e[f].hitZone&&a(b,e[f].hitZone.coordinates[0]))return c.transformToLatLon(b,e[f]);return c.transformToLatLon(b,e["default"])}e=this.projectedUnitsToPixels(b);f=0;for(var d=this.insets;f<d.length;f++)if(c=d[f],c.hitZone&&a(e,c.hitZone.coordinates[0]))return b=c.pixelsToProjectedUnits(e),b=c.projection.inverse([b.x,b.y]),{lon:b[0],lat:b[1]};b=this.projection.inverse([b.x,b.y]);return{lon:b[0],lat:b[1]}};d.prototype.redraw=function(a){this.chart.series.forEach(function(a){a.useMapGeometry&&
(a.isDirty=!0)});this.chart.redraw(a)};d.prototype.setView=function(a,b,c,e){void 0===c&&(c=!0);a&&(this.center=a);"number"===typeof b&&("number"===typeof this.minZoom&&(b=Math.max(b,this.minZoom)),"number"===typeof this.options.maxZoom&&(b=Math.min(b,this.options.maxZoom)),B(b)&&(this.zoom=b));var f=this.getProjectedBounds();if(f){a=this.projection.forward(this.center);var d=this.playingField;b=d.x;var g=d.y,m=d.width;d=d.height;var h=this.getScale(),q=this.projectedUnitsToPixels({x:f.x1,y:f.y1}),
l=this.projectedUnitsToPixels({x:f.x2,y:f.y2});f=[(f.x1+f.x2)/2,(f.y1+f.y2)/2];var k=q.x,u=l.y;l=l.x;q=q.y;l-k<m?a[0]=f[0]:k<b&&l<b+m?a[0]+=Math.max(k-b,l-m-b)/h:l>b+m&&k>b&&(a[0]+=Math.min(l-m-b,k-b)/h);q-u<d?a[1]=f[1]:u<g&&q<g+d?a[1]-=Math.max(u-g,q-d-g)/h:q>g+d&&u>g&&(a[1]-=Math.min(q-d-g,u-g)/h);this.center=this.projection.inverse(a);this.insets.forEach(function(a){a.options.field&&(a.hitZone=a.getHitZone(),a.playingField=a.getField())});this.render()}t(this,"afterSetView");c&&this.redraw(e)};
d.prototype.projectedUnitsToPixels=function(a){var b=this.getScale(),c=this.projection.forward(this.center),e=this.playingField;return{x:e.x+e.width/2-b*(c[0]-a.x),y:e.y+e.height/2+b*(c[1]-a.y)}};d.prototype.pixelsToLonLat=function(a){return this.projectedUnitsToLonLat(this.pixelsToProjectedUnits(a))};d.prototype.pixelsToProjectedUnits=function(a){var b=a.x;a=a.y;var c=this.getScale(),e=this.projection.forward(this.center),f=this.playingField;return{x:e[0]+(b-(f.x+f.width/2))/c,y:e[1]-(a-(f.y+f.height/
2))/c}};d.prototype.setUpEvents=function(){var a=this,b=this.chart,c,f,d,g=function(e){var g=b.pointer.pinchDown,m=a.projection,h=b.mouseDownX,l=b.mouseDownY;1===g.length&&(h=g[0].chartX,l=g[0].chartY);if("number"===typeof h&&"number"===typeof l){var k="".concat(h,",").concat(l),t=e.originalEvent;g=t.chartX;t=t.chartY;k!==f&&(f=k,c=a.projection.forward(a.center),d=(a.projection.options.rotation||[0,0]).slice());k=(k=m.def&&m.def.bounds)&&G(k,a.playingField)||-Infinity;"Orthographic"===m.options.name&&
(a.minZoom||Infinity)<1.1*k?(m=440/(a.getScale()*Math.min(b.plotWidth,b.plotHeight)),d&&(h=(h-g)*m-d[0],l=q(-d[1]-(l-t)*m,-80,80),g=a.zoom,a.update({projection:{rotation:[-h,-l]}},!1),a.zoom=g,b.redraw(!1))):B(g)&&B(t)&&(m=a.getScale(),l=a.projection.inverse([c[0]+(h-g)/m,c[1]-(l-t)/m*(a.projection.hasCoordinates?1:-1)]),a.setView(l,void 0,!0,!1));e.preventDefault()}};e(b,"pan",g);e(b,"touchpan",g);e(b,"selection",function(c){if(c.resetSelection)a.zoomBy();else{var e=c.x-b.plotLeft,f=c.y-b.plotTop,
d=a.pixelsToProjectedUnits({x:e,y:f}),g=d.y;d=d.x;e=a.pixelsToProjectedUnits({x:e+c.width,y:f+c.height});a.fitToBounds({x1:d,y1:g,x2:e.x,y2:e.y},void 0,!0,c.originalEvent.touches?!1:void 0);/^touch/.test(c.originalEvent.type)||b.showResetZoom();c.preventDefault()}})};d.prototype.render=function(){this.group||(this.group=this.chart.renderer.g("map-view").attr({zIndex:4}).add())};d.prototype.update=function(a,b,c){void 0===b&&(b=!0);var e=a.projection;e=e&&h.toString(e)!==h.toString(this.options.projection);
var f=!1;A(!0,this.userOptions,a);A(!0,this.options,a);"insets"in a&&(this.insets.forEach(function(a){return a.destroy()}),this.insets.length=0,f=!0);(e||"fitToGeometry"in a)&&delete this.fitToGeometryCache;if(e||f)this.chart.series.forEach(function(a){var b=a.transformGroups;a.clearBounds&&a.clearBounds();a.isDirty=!0;a.isDirtyData=!0;if(f&&b)for(;1<b.length;)(a=b.pop())&&a.destroy()}),e&&(this.projection=new h(this.options.projection)),f&&this.createInsets(),a.center||B(a.zoom)||this.fitToBounds(void 0,
void 0,!1);a.center||B(a.zoom)?this.setView(this.options.center,a.zoom,!1):"fitToGeometry"in a&&this.fitToBounds(void 0,void 0,!1);b&&this.chart.redraw(c)};d.prototype.zoomBy=function(a,b,c,e){var f=this.chart,d=this.projection.forward(this.center);b=b?this.projection.forward(b):[];var g=b[0],m=b[1];"number"===typeof a?(a=this.zoom+a,b=void 0,c&&(g=c[0],m=c[1],c=this.getScale(),g=g-f.plotLeft-f.plotWidth/2,f=m-f.plotTop-f.plotHeight/2,g=d[0]+g/c,m=d[1]+f/c),"number"===typeof g&&"number"===typeof m&&
(c=1-Math.pow(2,this.zoom)/Math.pow(2,a),g=d[0]-g,f=d[1]-m,d[0]-=g*c,d[1]+=f*c,b=this.projection.inverse(d)),this.setView(b,a,void 0,e)):this.fitToBounds(void 0,void 0,void 0,e)};d.compositeBounds=function(a){if(a.length)return a.slice(1).reduce(function(a,b){a.x1=Math.min(a.x1,b.x1);a.y1=Math.min(a.y1,b.y1);a.x2=Math.max(a.x2,b.x2);a.y2=Math.max(a.y2,b.y2);return a},A(a[0]))};return d}(),D=function(c){function e(a,e){var f=c.call(this,a.chart,e)||this;f.id=e.id;f.mapView=a;f.options=A(k,e);f.allBounds=
[];f.options.geoBounds&&(a=a.projection.path(f.options.geoBounds),f.geoBoundsProjectedBox=b(a),f.geoBoundsProjectedPolygon=a.map(function(a){return[a[1]||0,a[2]||0]}));return f}y(e,c);e.prototype.getField=function(a){void 0===a&&(a=!0);var b=this.hitZone;if(b){var e=a?this.padding:[0,0,0,0];b=b.coordinates[0];var f=b.map(function(a){return a[0]}),d=b.map(function(a){return a[1]});b=Math.min.apply(0,f)+e[3];f=Math.max.apply(0,f)-e[1];var g=Math.min.apply(0,d)+e[0];e=Math.max.apply(0,d)-e[2];if(B(b)&&
B(g))return{x:b,y:g,width:f-b,height:e-g}}return c.prototype.getField.call(this,a)};e.prototype.getHitZone=function(){var a=this.chart,b=this.mapView,c=this.options,e=(c.field||{}).coordinates;if(e){e=e[0];if("percent"===c.units){var f="mapBoundingBox"===c.relativeTo&&b.getMapBBox()||A(a.plotBox,{x:0,y:0});e=e.map(function(a){return[x("".concat(a[0],"%"),f.width,f.x),x("".concat(a[1],"%"),f.height,f.y)]})}return{type:"Polygon",coordinates:[e]}}};e.prototype.getProjectedBounds=function(){return E.compositeBounds(this.allBounds)};
e.prototype.isInside=function(b){var c=this.geoBoundsProjectedBox,e=this.geoBoundsProjectedPolygon;return!!(c&&b.x>=c.x1&&b.x<=c.x2&&b.y>=c.y1&&b.y<=c.y2&&e&&a(b,e))};e.prototype.render=function(){var a=this.chart,b=this.mapView,c=this.options,e=c.borderPath||c.field;if(e&&b.group){var f=!0;this.border||(this.border=a.renderer.path().addClass("highcharts-mapview-inset-border").add(b.group),f=!1);a.styledMode||this.border.attr({stroke:c.borderColor,"stroke-width":c.borderWidth});var d=Math.round(this.border.strokeWidth())%
2/2,g="mapBoundingBox"===c.relativeTo&&b.getMapBBox()||b.playingField;b=(e.coordinates||[]).reduce(function(b,e){return e.reduce(function(b,e,f){var m=e[0];e=e[1];"percent"===c.units&&(m=a.plotLeft+x("".concat(m,"%"),g.width,g.x),e=a.plotTop+x("".concat(e,"%"),g.height,g.y));m=Math.floor(m)+d;e=Math.floor(e)+d;b.push(0===f?["M",m,e]:["L",m,e]);return b},b)},[]);this.border[f?"animate":"attr"]({d:b})}};e.prototype.destroy=function(){this.border&&(this.border=this.border.destroy());this.eventsToUnbind.forEach(function(a){return a()})};
e.prototype.setUpEvents=function(){};return e}(E);e(l,"afterInit",function(){this.mapView=new E(this,this.options.mapView)});return E});z(c,"Series/Map/MapSeries.js",[c["Core/Animation/AnimationUtilities.js"],c["Series/ColorMapComposition.js"],c["Series/CenteredUtilities.js"],c["Core/Globals.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Chart/MapChart.js"],c["Series/Map/MapPoint.js"],c["Maps/MapView.js"],c["Core/Series/Series.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Renderer/SVG/SVGRenderer.js"],
c["Core/Utilities.js"]],function(c,k,p,l,n,h,d,y,r,g,v,b){var a=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===
c?Object.create(c):(e.prototype=c.prototype,new e)}}(),e=c.animObject;c=l.noop;var q=h.splitPath;h=g.seriesTypes;var t=h.column,m=h.scatter;h=b.extend;var B=b.find,u=b.fireEvent,f=b.getNestedProperty,A=b.isArray,C=b.defined,x=b.isNumber,G=b.isObject,E=b.merge,D=b.objectEach,F=b.pick,w=b.splat;b=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.chart=void 0;a.data=void 0;a.group=void 0;a.joinBy=void 0;a.options=void 0;a.points=void 0;a.processedData=[];return a}a(c,b);c.prototype.animate=
function(a){var b=this.chart,c=this.group,f=e(this.options.animation);b.renderer.isSVG&&(a?c.attr({translateX:b.plotLeft+b.plotWidth/2,translateY:b.plotTop+b.plotHeight/2,scaleX:.001,scaleY:.001}):c.animate({translateX:b.plotLeft,translateY:b.plotTop,scaleX:1,scaleY:1},f))};c.prototype.animateDrilldown=function(a){var b=this.chart,c=this.group;b.renderer.isSVG&&(a?c.attr({translateX:b.plotLeft+b.plotWidth/2,translateY:b.plotTop+b.plotHeight/2,scaleX:.1,scaleY:.1,opacity:.01}):(c.animate({translateX:b.plotLeft,
translateY:b.plotTop,scaleX:1,scaleY:1,opacity:1},this.chart.options.drilldown.animation),b.drilldown&&b.drilldown.fadeInGroup(this.dataLabelsGroup)))};c.prototype.animateDrillupFrom=function(){var a=this.chart;a.renderer.isSVG&&this.group.animate({translateX:a.plotLeft+a.plotWidth/2,translateY:a.plotTop+a.plotHeight/2,scaleX:.1,scaleY:.1,opacity:.01})};c.prototype.animateDrillupTo=function(a){t.prototype.animateDrillupTo.call(this,a)};c.prototype.clearBounds=function(){this.points.forEach(function(a){delete a.bounds;
delete a.insetIndex;delete a.projectedPath});delete this.bounds};c.prototype.doFullTranslate=function(){return!(!(this.isDirtyData||this.chart.isResizing||this.chart.renderer.isVML)&&this.hasRendered)};c.prototype.drawMapDataLabels=function(){r.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};c.prototype.drawPoints=function(){var a=this,b=this,c=this.chart,e=this.group,f=this.transformGroups,d=void 0===f?[]:f,g=c.mapView,m=c.renderer;g&&(this.transformGroups=
d,d[0]||(d[0]=m.g().add(e)),g.insets.forEach(function(a,b){d[b+1]||d.push(m.g().add(e))}),this.doFullTranslate()&&(this.points.forEach(function(b){var e=b.graphic,f=b.shapeArgs;b.group=d["number"===typeof b.insetIndex?b.insetIndex+1:0];e&&e.parentGroup!==b.group&&e.add(b.group);f&&c.hasRendered&&!c.styledMode&&(f.fill=a.pointAttribs(b,b.state).fill)}),t.prototype.drawPoints.apply(this),this.points.forEach(function(e){var f=e.graphic;if(f){var d=f.animate,g="";e.name&&(g+="highcharts-name-"+e.name.replace(/ /g,
"-").toLowerCase());e.properties&&e.properties["hc-key"]&&(g+=" highcharts-key-"+e.properties["hc-key"].toString().toLowerCase());g&&f.addClass(g);c.styledMode&&f.css(a.pointAttribs(e,e.selected&&"select"||void 0));f.animate=function(a,e,g){var m=x(a["stroke-width"])&&!x(f["stroke-width"]),h=x(f["stroke-width"])&&!x(a["stroke-width"]);if(m||h){var q=F(b.getStrokeWidth(b.options),1)/(c.mapView&&c.mapView.getScale()||1);m&&(f["stroke-width"]=q);h&&(a["stroke-width"]=q)}return d.call(f,a,e,h?function(){f.element.removeAttribute("stroke-width");
delete f["stroke-width"];g&&g.apply(this,arguments)}:g)}}})),d.forEach(function(e,f){var d=(0===f?g:g.insets[f-1]).getSVGTransform(),h=F(a.getStrokeWidth(a.options),1),q=d.scaleX,l=0<d.scaleY?1:-1,k=function(c){(b.points||[]).forEach(function(b){var e=b.graphic,f;e&&e["stroke-width"]&&(f=a.getStrokeWidth(b.options))&&e.attr({"stroke-width":f/c})})};if(m.globalAnimation&&c.hasRendered){var t=Number(e.attr("translateX")),u=Number(e.attr("translateY")),n=Number(e.attr("scaleX"));e.attr({animator:0}).animate({animator:1},
{step:function(a,b){a=n+(q-n)*b.pos;e.attr({translateX:t+(d.translateX-t)*b.pos,translateY:u+(d.translateY-u)*b.pos,scaleX:a,scaleY:a*l,"stroke-width":h/a});k(a)}})}else e.attr(E(d,{"stroke-width":h/q})),k(q)}),this.drawMapDataLabels())};c.prototype.getProjectedBounds=function(){if(!this.bounds&&this.chart.mapView){var a=this.chart.mapView,b=a.insets,c=a.projection,e=[];(this.points||[]).forEach(function(a){if(a.path||a.geometry){"string"===typeof a.path?a.path=q(a.path):A(a.path)&&"M"===a.path[0]&&
(a.path=v.prototype.pathToSegments(a.path));if(!a.bounds){var f=a.getProjectedBounds(c);if(f){a.labelrank=F(a.labelrank,(f.x2-f.x1)*(f.y2-f.y1));var d=f.midX,g=f.midY;if(b&&x(d)&&x(g)){var m=B(b,function(a){return a.isInside({x:d,y:g})});m&&(delete a.projectedPath,(f=a.getProjectedBounds(m.projection))&&m.allBounds.push(f),a.insetIndex=b.indexOf(m))}a.bounds=f}}a.bounds&&void 0===a.insetIndex&&e.push(a.bounds)}});this.bounds=y.compositeBounds(e)}return this.bounds};c.prototype.getStrokeWidth=function(a){var b=
this.pointAttrToOptions;return a[b&&b["stroke-width"]||"borderWidth"]};c.prototype.hasData=function(){return!!this.processedXData.length};c.prototype.pointAttribs=function(a,b){var c=a.series.chart,e=c.mapView;c=c.styledMode?this.colorAttribs(a):t.prototype.pointAttribs.call(this,a,b);var f=this.getStrokeWidth(a.options);b&&(b=E(this.options.states[b],a.options.states&&a.options.states[b]||{}),b=this.getStrokeWidth(b),C(b)&&(f=b));f&&e&&(f/=e.getScale());b=this.getStrokeWidth(this.options);c.dashstyle&&
e&&x(b)&&(f=b/e.getScale());a.visible||(c.fill=this.options.nullColor);C(f)?c["stroke-width"]=f:delete c["stroke-width"];c["stroke-linecap"]=c["stroke-linejoin"]=this.options.linecap;return c};c.prototype.updateData=function(){return this.processedData?!1:b.prototype.updateData.apply(this,arguments)};c.prototype.setData=function(a,c,e,f){void 0===c&&(c=!0);delete this.bounds;b.prototype.setData.call(this,a,!1,void 0,f);this.processData();this.generatePoints();c&&this.chart.redraw(e)};c.prototype.processData=
function(){var a=this.options,b=a.data,c=this.chart.options.chart,e=this.joinBy,g=a.keys||this.pointArrayMap,m=[],h={},q=this.chart.mapView;q=q&&(G(a.mapData,!0)?q.getGeoMap(a.mapData):q.geoMap);var k=this.chart.mapTransforms;(this.chart.mapTransforms=k=c.mapTransforms||q&&q["hc-transform"]||k)&&D(k,function(a){a.rotation&&(a.cosAngle=Math.cos(a.rotation),a.sinAngle=Math.sin(a.rotation))});if(A(a.mapData))var t=a.mapData;else q&&"FeatureCollection"===q.type&&(this.mapTitle=q.title,t=l.geojson(q,this.type,
this));var u=this.processedData=[];b&&b.forEach(function(c,f){var m=0;if(x(c))u[f]={value:c};else if(A(c)){u[f]={};!a.keys&&c.length>g.length&&"string"===typeof c[0]&&(u[f]["hc-key"]=c[0],++m);for(var h=0;h<g.length;++h,++m)g[h]&&"undefined"!==typeof c[m]&&(0<g[h].indexOf(".")?d.prototype.setNestedProperty(u[f],c[m],g[h]):u[f][g[h]]=c[m])}else u[f]=b[f];e&&"_i"===e[0]&&(u[f]._i=f)});if(t){this.mapData=t;this.mapMap={};for(k=0;k<t.length;k++)c=t[k],q=c.properties,c._i=k,e[0]&&q&&q[e[0]]&&(c[e[0]]=
q[e[0]]),h[c[e[0]]]=c;this.mapMap=h;if(e[1]){var n=e[1];u.forEach(function(a){a=f(n,a);h[a]&&m.push(h[a])})}if(a.allAreas){if(e[1]){var p=e[1];u.forEach(function(a){m.push(f(p,a))})}var r="|"+m.map(function(a){return a&&a[e[0]]}).join("|")+"|";t.forEach(function(a){e[0]&&-1!==r.indexOf("|"+a[e[0]]+"|")||u.push(E(a,{value:null}))})}}this.processedXData=Array(u.length)};c.prototype.setOptions=function(a){a=r.prototype.setOptions.call(this,a);var b=a.joinBy;null===b&&(b="_i");b=this.joinBy=w(b);b[1]||
(b[1]=b[0]);return a};c.prototype.translate=function(){var a=this.doFullTranslate(),b=this.chart.mapView,c=b&&b.projection;!this.chart.hasRendered||!this.isDirtyData&&this.hasRendered||(this.processData(),this.generatePoints(),delete this.bounds,!b||b.userOptions.center||x(b.userOptions.zoom)?this.getProjectedBounds():b.fitToBounds(void 0,void 0,!1));if(b){var e=b.getSVGTransform();this.points.forEach(function(f){var g=x(f.insetIndex)&&b.insets[f.insetIndex].getSVGTransform()||e;g&&f.bounds&&x(f.bounds.midX)&&
x(f.bounds.midY)&&(f.plotX=f.bounds.midX*g.scaleX+g.translateX,f.plotY=f.bounds.midY*g.scaleY+g.translateY);a&&(f.shapeType="path",f.shapeArgs={d:d.getProjectedPath(f,c)})})}u(this,"afterTranslate")};c.defaultOptions=E(m.defaultOptions,{affectsMapView:!0,animation:!1,dataLabels:{crop:!1,formatter:function(){var a=this.series.chart.numberFormatter,b=this.point.value;return x(b)?a(b,-1):""},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},linecap:"butt",marker:null,nullColor:"#f7f7f7",stickyTracking:!1,
tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:"#cccccc",borderWidth:1,joinBy:"hc-key",states:{hover:{halo:null,brightness:.2},normal:{animation:!0},select:{color:"#cccccc"}}});return c}(m);h(b.prototype,{type:"map",axisTypes:k.seriesMembers.axisTypes,colorAttribs:k.seriesMembers.colorAttribs,colorKey:k.seriesMembers.colorKey,directTouch:!0,drawDataLabels:c,drawGraph:c,drawLegendSymbol:n.drawRectangle,forceDL:!0,getCenter:p.getCenter,
getExtremesFromAll:!0,getSymbol:c,isCartesian:!1,parallelArrays:k.seriesMembers.parallelArrays,pointArrayMap:k.seriesMembers.pointArrayMap,pointClass:d,preserveAspectRatio:!0,searchPoint:c,trackerGroups:k.seriesMembers.trackerGroups,useMapGeometry:!0});k.compose(b);g.registerSeriesType("map",b);"";return b});z(c,"Series/MapLine/MapLineSeries.js",[c["Series/Map/MapSeries.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,p){var l=this&&this.__extends||function(){var c=function(d,
g){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,b){c.__proto__=b}||function(c,b){for(var a in b)Object.prototype.hasOwnProperty.call(b,a)&&(c[a]=b[a])};return c(d,g)};return function(d,g){function h(){this.constructor=d}if("function"!==typeof g&&null!==g)throw new TypeError("Class extends value "+String(g)+" is not a constructor or null");c(d,g);d.prototype=null===g?Object.create(g):(h.prototype=g.prototype,new h)}}(),n=k.series,h=p.extend,d=p.merge;p=function(h){function k(){var c=
null!==h&&h.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}l(k,h);k.prototype.pointAttribs=function(d,h){d=c.prototype.pointAttribs.call(this,d,h);d.fill=this.options.fillColor;return d};k.defaultOptions=d(c.defaultOptions,{lineWidth:1,fillColor:"none"});return k}(c);h(p.prototype,{type:"mapline",colorProp:"stroke",drawLegendSymbol:n.prototype.drawLegendSymbol,pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"}});k.registerSeriesType("mapline",p);"";
return p});z(c,"Series/MapPoint/MapPointPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k){var p=this&&this.__extends||function(){var c=function(h,d){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,d){c.__proto__=d}||function(c,d){for(var g in d)Object.prototype.hasOwnProperty.call(d,g)&&(c[g]=d[g])};return c(h,d)};return function(h,d){function k(){this.constructor=h}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+
String(d)+" is not a constructor or null");c(h,d);h.prototype=null===d?Object.create(d):(k.prototype=d.prototype,new k)}}(),l=k.isNumber;return function(c){function h(){var d=null!==c&&c.apply(this,arguments)||this;d.options=void 0;d.series=void 0;return d}p(h,c);h.prototype.isValid=function(){return!!(this.options.geometry||l(this.x)&&l(this.y)||l(this.options.lon)&&l(this.options.lat))};return h}(c.seriesTypes.scatter.prototype.pointClass)});z(c,"Series/MapPoint/MapPointSeries.js",[c["Core/Globals.js"],
c["Series/MapPoint/MapPointPoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,k,p,l,n){var h=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+
String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}();c=c.noop;var d=p.seriesTypes,y=d.map,r=d.scatter;d=n.extend;var g=n.fireEvent,v=n.isNumber,b=n.merge;n=function(a){function c(){var b=null!==a&&a.apply(this,arguments)||this;b.chart=void 0;b.data=void 0;b.options=void 0;b.points=void 0;b.clearBounds=y.prototype.clearBounds;return b}h(c,a);c.prototype.drawDataLabels=function(){a.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&
this.dataLabelsGroup.clip(this.chart.clipRect)};c.prototype.projectPoint=function(a){var b=this.chart.mapView;if(b){var c=a.geometry,e=a.lon;a=a.lat;c=c&&"Point"===c.type&&c.coordinates;v(e)&&v(a)&&(c=[e,a]);if(c)return b.lonLatToProjectedUnits({lon:c[0],lat:c[1]})}};c.prototype.translate=function(){var a=this,b=this.chart.mapView;this.processedXData||this.processData();this.generatePoints();this.getProjectedBounds&&this.isDirtyData&&(delete this.bounds,this.getProjectedBounds());if(b){var c=b.getSVGTransform(),
e=b.projection.hasCoordinates;this.points.forEach(function(d){var f=d.x;f=void 0===f?void 0:f;var g=d.y;g=void 0===g?void 0:g;var m=v(d.insetIndex)&&b.insets[d.insetIndex].getSVGTransform()||c,h=a.projectPoint(d.options)||d.properties&&a.projectPoint(d.properties);if(h)f=h.x,g=h.y;else if(d.bounds&&(f=d.bounds.midX,g=d.bounds.midY,m&&v(f)&&v(g))){d.plotX=f*m.scaleX+m.translateX;d.plotY=g*m.scaleY+m.translateY;var k=!0}v(f)&&v(g)?k||(k=b.projectedUnitsToPixels({x:f,y:g}),d.plotX=k.x,d.plotY=e?k.y:
a.chart.plotHeight-k.y):d.y=d.plotX=d.plotY=void 0;d.isInside=a.isPointInside(d);d.zone=a.zones.length?d.getZone():void 0})}g(this,"afterTranslate")};c.defaultOptions=b(r.defaultOptions,{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}}});return c}(r);l.prototype.symbols.mapmarker=function(a,b,c,d,g){var e=g&&"legend"===g.context;e?(a+=c/2,g=b+d):g&&"number"===typeof g.anchorX&&"number"===typeof g.anchorY?(a=g.anchorX,g=g.anchorY):
(a+=c/2,g=b+d/2,b-=d);d=e?d/3:d/2;return[["M",a,g],["C",a,g,a-d,b+1.5*d,a-d,b+d],["A",d,d,1,1,1,a+d,b+d],["C",a+d,b+1.5*d,a,g,a,g],["Z"]]};d(n.prototype,{type:"mappoint",axisTypes:["colorAxis"],forceDL:!0,isCartesian:!1,pointClass:k,searchPoint:c,useMapGeometry:!0});p.registerSeriesType("mappoint",n);"";return n});z(c,"Series/Bubble/BubbleLegendDefaults.js",[],function(){return{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,
connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"10px",color:"#000000"},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}});z(c,"Series/Bubble/BubbleLegendItem.js",[c["Core/Color/Color.js"],c["Core/FormatUtilities.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,k,p,l){var n=c.parse,
h=p.noop,d=l.arrayMax,y=l.arrayMin,r=l.isNumber,g=l.merge,v=l.pick,b=l.stableSort;c=function(){function a(a,b){this.options=this.symbols=this.visible=this.selected=this.ranges=this.movementX=this.maxLabel=this.legend=this.fontMetrics=this.chart=void 0;this.setState=h;this.init(a,b)}a.prototype.init=function(a,b){this.options=a;this.visible=!0;this.chart=b.chart;this.legend=b};a.prototype.addToLegend=function(a){a.splice(this.options.legendIndex,0,this)};a.prototype.drawLegendSymbol=function(a){var c=
this.chart,e=v(a.options.itemDistance,20),d=this.legendItem||{},g=this.options,h=g.ranges,f=g.connectorDistance;this.fontMetrics=c.renderer.fontMetrics(g.labels.style.fontSize);h&&h.length&&r(h[0].value)?(b(h,function(a,b){return b.value-a.value}),this.ranges=h,this.setOptions(),this.render(),a=this.getMaxLabelSize(),h=this.ranges[0].radius,c=2*h,f=f-h+a.width,f=0<f?f:0,this.maxLabel=a,this.movementX="left"===g.labels.align?f:0,d.labelWidth=c+f+e,d.labelHeight=c+this.fontMetrics.h/2):a.options.bubbleLegend.autoRanges=
!0};a.prototype.setOptions=function(){var a=this.ranges,b=this.options,c=this.chart.series[b.seriesIndex],d=this.legend.baseline,h={zIndex:b.zIndex,"stroke-width":b.borderWidth},k={zIndex:b.zIndex,"stroke-width":b.connectorWidth},f={align:this.legend.options.rtl||"left"===b.labels.align?"right":"left",zIndex:b.zIndex},l=c.options.marker.fillOpacity,p=this.chart.styledMode;a.forEach(function(e,m){p||(h.stroke=v(e.borderColor,b.borderColor,c.color),h.fill=v(e.color,b.color,1!==l?n(c.color).setOpacity(l).get("rgba"):
c.color),k.stroke=v(e.connectorColor,b.connectorColor,c.color));a[m].radius=this.getRangeRadius(e.value);a[m]=g(a[m],{center:a[0].radius-a[m].radius+d});p||g(!0,a[m],{bubbleAttribs:g(h),connectorAttribs:g(k),labelAttribs:f})},this)};a.prototype.getRangeRadius=function(a){var b=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,b.ranges[b.ranges.length-1].value,b.ranges[0].value,b.minSize,b.maxSize,a)};a.prototype.render=function(){var a=this.legendItem||{},b=this.chart.renderer,
c=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]});a.symbol=b.g("bubble-legend");a.label=b.g("bubble-legend-item");a.symbol.translateX=0;b=a.symbol.translateY=0;for(var d=this.ranges;b<d.length;b++){var g=d[b];g.value>=c&&this.renderRange(g)}a.symbol.add(a.label);a.label.add(a.group);this.hideOverlappingLabels()};a.prototype.renderRange=function(a){var b=this.options,c=b.labels,e=this.chart,d=e.series[b.seriesIndex],g=e.renderer,f=this.symbols;e=f.labels;
var h=a.center,k=Math.abs(a.radius),l=b.connectorDistance||0,n=c.align,p=b.connectorWidth,r=this.ranges[0].radius||0,v=h-k-b.borderWidth/2+p/2,w=this.fontMetrics;w=w.f/2-(w.h-w.f)/2;var y=g.styledMode;l=this.legend.options.rtl||"left"===n?-l:l;"center"===n&&(l=0,b.connectorDistance=0,a.labelAttribs.align="center");n=v+b.labels.y;var D=r+l+b.labels.x;f.bubbleItems.push(g.circle(r,h+((v%1?1:.5)-(p%2?0:.5)),k).attr(y?{}:a.bubbleAttribs).addClass((y?"highcharts-color-"+d.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+
(b.className||"")).add(this.legendItem.symbol));f.connectors.push(g.path(g.crispLine([["M",r,v],["L",r+l,v]],b.connectorWidth)).attr(y?{}:a.connectorAttribs).addClass((y?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(b.connectorClassName||"")).add(this.legendItem.symbol));a=g.text(this.formatLabel(a),D,n+w).attr(y?{}:a.labelAttribs).css(y?{}:c.style).addClass("highcharts-bubble-legend-labels "+(b.labels.className||"")).add(this.legendItem.symbol);e.push(a);
a.placed=!0;a.alignAttr={x:D,y:n+w}};a.prototype.getMaxLabelSize=function(){var a,b;this.symbols.labels.forEach(function(c){b=c.getBBox(!0);a=a?b.width>a.width?b:a:b});return a||{}};a.prototype.formatLabel=function(a){var b=this.options,c=b.labels.formatter;b=b.labels.format;var e=this.chart.numberFormatter;return b?k.format(b,a):c?c.call(a):e(a.value,1)};a.prototype.hideOverlappingLabels=function(){var a=this.chart,b=this.symbols;!this.options.labels.allowOverlap&&b&&(a.hideOverlappingLabels(b.labels),
b.labels.forEach(function(a,c){a.newOpacity?a.newOpacity!==a.oldOpacity&&b.connectors[c].show():b.connectors[c].hide()}))};a.prototype.getRanges=function(){var a=this.legend.bubbleLegend,b=a.options.ranges,c,h=Number.MAX_VALUE,k=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&!a.ignoreSeries&&(c=a.zData.filter(r),c.length&&(h=v(a.options.zMin,Math.min(h,Math.max(y(c),!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),k=v(a.options.zMax,Math.max(k,d(c)))))});
var l=h===k?[{value:k}]:[{value:h},{value:(h+k)/2},{value:k,autoRanges:!0}];b.length&&b[0].radius&&l.reverse();l.forEach(function(a,c){b&&b[c]&&(l[c]=g(b[c],a))});return l};a.prototype.predictBubbleSizes=function(){var a=this.chart,b=this.fontMetrics,c=a.legend.options,d=c.floating,g=(c="horizontal"===c.layout)?a.legend.lastLineHeight:0,h=a.plotSizeX,f=a.plotSizeY,k=a.series[this.options.seriesIndex],l=k.getPxExtremes();a=Math.ceil(l.minPxSize);l=Math.ceil(l.maxPxSize);var n=Math.min(f,h);k=k.options.maxSize;
if(d||!/%$/.test(k))b=l;else if(k=parseFloat(k),b=(n+g-b.h/2)*k/100/(k/100+1),c&&f-b>=h||!c&&h-b>=f)b=l;return[a,Math.ceil(b)]};a.prototype.updateRanges=function(a,b){var c=this.legend.options.bubbleLegend;c.minSize=a;c.maxSize=b;c.ranges=this.getRanges()};a.prototype.correctSizes=function(){var a=this.legend,b=this.chart.series[this.options.seriesIndex].getPxExtremes();1<Math.abs(Math.ceil(b.maxPxSize)-this.options.maxSize)&&(this.updateRanges(this.options.minSize,b.maxPxSize),a.render())};return a}();
"";return c});z(c,"Series/Bubble/BubbleLegendComposition.js",[c["Series/Bubble/BubbleLegendDefaults.js"],c["Series/Bubble/BubbleLegendItem.js"],c["Core/Defaults.js"],c["Core/Utilities.js"]],function(c,k,p,l){function n(b,c,e){var m=this.legend,f=0<=h(this),k;if(m&&m.options.enabled&&m.bubbleLegend&&m.options.bubbleLegend.autoRanges&&f){var l=m.bubbleLegend.options;f=m.bubbleLegend.predictBubbleSizes();m.bubbleLegend.updateRanges(f[0],f[1]);l.placed||(m.group.placed=!1,m.allItems.forEach(function(a){k=
a.legendItem||{};k.group&&(k.group.translateY=null)}));m.render();this.getMargins();this.axes.forEach(function(b){b.visible&&b.render();l.placed||(b.setScale(),b.updateNames(),a(b.ticks,function(a){a.isNew=!0;a.isNewLabel=!0}))});l.placed=!0;this.getMargins();b.call(this,c,e);m.bubbleLegend.correctSizes();g(m,d(m))}else b.call(this,c,e),m&&m.options.enabled&&m.bubbleLegend&&(m.render(),g(m,d(m)))}function h(a){a=a.series;for(var b=0;b<a.length;){if(a[b]&&a[b].isBubble&&a[b].visible&&a[b].zData.length)return b;
b++}return-1}function d(a){a=a.allItems;var b=[],c=a.length,e,f=0;for(e=0;e<c;e++){var d=a[e].legendItem||{};var g=(a[e+1]||{}).legendItem||{};d.labelHeight&&(a[e].itemHeight=d.labelHeight);if(a[e]===a[c-1]||d.y!==g.y){b.push({height:0});d=b[b.length-1];for(f;f<=e;f++)a[f].itemHeight>d.height&&(d.height=a[f].itemHeight);d.step=e}}return b}function y(a){var b=this.bubbleLegend,c=this.options,e=c.bubbleLegend,f=h(this.chart);b&&b.ranges&&b.ranges.length&&(e.ranges.length&&(e.autoRanges=!!e.ranges[0].autoRanges),
this.destroyItem(b));0<=f&&c.enabled&&e.enabled&&(e.seriesIndex=f,this.bubbleLegend=new k(e,this),this.bubbleLegend.addToLegend(a.allItems))}function r(){var a=this.chart,b=this.visible,c=this.chart.legend;c&&c.bubbleLegend&&(this.visible=!b,this.ignoreSeries=b,a=0<=h(a),c.bubbleLegend.visible!==a&&(c.update({bubbleLegend:{enabled:a}}),c.bubbleLegend.visible=a),this.visible=b)}function g(a,b){var c=a.options.rtl,e,f,d,g,h=0;a.allItems.forEach(function(a,k){g=a.legendItem||{};if(g.group){e=g.group.translateX||
0;f=g.y||0;if((d=a.movementX)||c&&a.ranges)d=c?e-a.options.maxSize/2:e+d,g.group.attr({translateX:d});k>b[h].step&&h++;g.group.attr({translateY:Math.round(f+b[h].height/2)});g.y=f+b[h].height/2}})}var v=p.setOptions,b=l.addEvent,a=l.objectEach,e=l.wrap,q=[];return{compose:function(a,d,g){-1===q.indexOf(a)&&(q.push(a),v({legend:{bubbleLegend:c}}),e(a.prototype,"drawChartBox",n));-1===q.indexOf(d)&&(q.push(d),b(d,"afterGetAllItems",y));-1===q.indexOf(g)&&(q.push(g),b(g,"legendItemClick",r))}}});z(c,
"Series/Bubble/BubblePoint.js",[c["Core/Series/Point.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,p){var l=this&&this.__extends||function(){var c=function(h,d){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,d){c.__proto__=d}||function(c,d){for(var g in d)Object.prototype.hasOwnProperty.call(d,g)&&(c[g]=d[g])};return c(h,d)};return function(h,d){function k(){this.constructor=h}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+
String(d)+" is not a constructor or null");c(h,d);h.prototype=null===d?Object.create(d):(k.prototype=d.prototype,new k)}}();p=p.extend;k=function(k){function h(){var c=null!==k&&k.apply(this,arguments)||this;c.options=void 0;c.series=void 0;return c}l(h,k);h.prototype.haloPath=function(d){return c.prototype.haloPath.call(this,0===d?0:(this.marker?this.marker.radius||0:0)+d)};return h}(k.seriesTypes.scatter.prototype.pointClass);p(k.prototype,{ttBelow:!1});return k});z(c,"Series/Bubble/BubbleSeries.js",
[c["Series/Bubble/BubbleLegendComposition.js"],c["Series/Bubble/BubblePoint.js"],c["Core/Color/Color.js"],c["Core/Globals.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,p,l,n,h){function d(){var a=this,b=this.len,c=this.chart,e=this.isXAxis,d=e?"xData":"yData",f=this.min,g=this.max-f,h=0,k=b,l=b/g,n;this.series.forEach(function(b){if(b.bubblePadding&&(b.visible||!c.options.chart.ignoreHiddenSeries)){n=a.allowZoomOutside=!0;var p=b[d];e&&((b.onPoint||b).getRadii(0,0,b),
b.onPoint&&(b.radii=b.onPoint.radii));if(0<g)for(var q=p.length;q--;)if(m(p[q])&&a.dataMin<=p[q]&&p[q]<=a.max){var x=b.radii&&b.radii[q]||0;h=Math.min((p[q]-f)*l-x,h);k=Math.max((p[q]-f)*l+x,k)}}});n&&0<g&&!this.logarithmic&&(k-=b,l*=(b+Math.max(0,h)-Math.min(k,b))/b,[["min","userMin",h],["max","userMax",k]].forEach(function(b){"undefined"===typeof u(a.options[b[0]],a[b[1]])&&(a[b[0]]+=b[2]/l)}))}var y=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),r=p.parse;p=l.noop;var g=n.series,v=n.seriesTypes;l=v.column.prototype;var b=v.scatter;v=h.addEvent;var a=h.arrayMax,
e=h.arrayMin,q=h.clamp,t=h.extend,m=h.isNumber,z=h.merge,u=h.pick,f=[];h=function(h){function k(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.maxPxSize=void 0;a.minPxSize=void 0;a.options=void 0;a.points=void 0;a.radii=void 0;a.yData=void 0;a.zData=void 0;return a}y(k,h);k.compose=function(a,b,e,g){c.compose(b,e,g);-1===f.indexOf(a)&&(f.push(a),a.prototype.beforePadding=d)};k.prototype.animate=function(a){!a&&this.points.length<this.options.animationLimit&&this.points.forEach(function(a){var b=
a.graphic;b&&b.width&&(this.hasRendered||b.attr({x:a.plotX,y:a.plotY,width:1,height:1}),b.animate(this.markerAttribs(a),this.options.animation))},this)};k.prototype.getRadii=function(){var a=this,b=this.zData,c=this.yData,e=[],d=this.chart.bubbleZExtremes;var f=this.getPxExtremes();var g=f.minPxSize,h=f.maxPxSize;if(!d){var k=Number.MAX_VALUE,m=-Number.MAX_VALUE,l;this.chart.series.forEach(function(b){b.bubblePadding&&(b.visible||!a.chart.options.chart.ignoreHiddenSeries)&&(b=(b.onPoint||b).getZExtremes())&&
(k=Math.min(k||b.zMin,b.zMin),m=Math.max(m||b.zMax,b.zMax),l=!0)});l?(d={zMin:k,zMax:m},this.chart.bubbleZExtremes=d):d={zMin:0,zMax:0}}var n=0;for(f=b.length;n<f;n++){var p=b[n];e.push(this.getRadius(d.zMin,d.zMax,g,h,p,c&&c[n]))}this.radii=e};k.prototype.getRadius=function(a,b,c,e,d,f){var g=this.options,h="width"!==g.sizeBy,k=g.zThreshold,l=b-a,n=.5;if(null===f||null===d)return null;if(m(d)){g.sizeByAbsoluteValue&&(d=Math.abs(d-k),l=Math.max(b-k,Math.abs(a-k)),a=0);if(d<a)return c/2-1;0<l&&(n=
(d-a)/l)}h&&0<=n&&(n=Math.sqrt(n));return Math.ceil(c+n*(e-c))/2};k.prototype.hasData=function(){return!!this.processedXData.length};k.prototype.pointAttribs=function(a,b){var c=this.options.marker.fillOpacity;a=g.prototype.pointAttribs.call(this,a,b);1!==c&&(a.fill=r(a.fill).setOpacity(c).get("rgba"));return a};k.prototype.translate=function(){h.prototype.translate.call(this);this.getRadii();this.translateBubble()};k.prototype.translateBubble=function(){for(var a=this.data,b=this.radii,c=this.getPxExtremes().minPxSize,
e=a.length;e--;){var d=a[e],f=b?b[e]:0;m(f)&&f>=c/2?(d.marker=t(d.marker,{radius:f,width:2*f,height:2*f}),d.dlBox={x:d.plotX-f,y:d.plotY-f,width:2*f,height:2*f}):(d.shapeArgs=d.plotY=d.dlBox=void 0,d.isInside=!1)}};k.prototype.getPxExtremes=function(){var a=Math.min(this.chart.plotWidth,this.chart.plotHeight),b=function(b){if("string"===typeof b){var c=/%$/.test(b);b=parseInt(b,10)}return c?a*b/100:b},c=b(u(this.options.minSize,8));b=Math.max(b(u(this.options.maxSize,"20%")),c);return{minPxSize:c,
maxPxSize:b}};k.prototype.getZExtremes=function(){var b=this.options,c=(this.zData||[]).filter(m);if(c.length){var d=u(b.zMin,q(e(c),!1===b.displayNegative?b.zThreshold||0:-Number.MAX_VALUE,Number.MAX_VALUE));b=u(b.zMax,a(c));if(m(d)&&m(b))return{zMin:d,zMax:b}}};k.defaultOptions=z(b.defaultOptions,{dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,b=this.point.z;return m(b)?a(b,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,
fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"});return k}(b);t(h.prototype,{alignDataLabel:l.alignDataLabel,applyZones:p,bubblePadding:!0,buildKDTree:p,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:k,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",
zoneAxis:"z"});v(h,"updatedData",function(a){delete a.target.chart.bubbleZExtremes});v(h,"remove",function(a){delete a.target.chart.bubbleZExtremes});n.registerSeriesType("bubble",h);"";"";return h});z(c,"Series/MapBubble/MapBubblePoint.js",[c["Series/Bubble/BubblePoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,p){var l=this&&this.__extends||function(){var c=function(h,d){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,d){c.__proto__=d}||function(c,
d){for(var g in d)Object.prototype.hasOwnProperty.call(d,g)&&(c[g]=d[g])};return c(h,d)};return function(h,d){function k(){this.constructor=h}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");c(h,d);h.prototype=null===d?Object.create(d):(k.prototype=d.prototype,new k)}}();k=k.seriesTypes.map.prototype.pointClass.prototype;p=p.extend;c=function(c){function h(){return null!==c&&c.apply(this,arguments)||this}l(h,c);h.prototype.isValid=
function(){return"number"===typeof this.z};return h}(c);p(c.prototype,{applyOptions:k.applyOptions,getProjectedBounds:k.getProjectedBounds});return c});z(c,"Series/MapBubble/MapBubbleSeries.js",[c["Series/Bubble/BubbleSeries.js"],c["Series/MapBubble/MapBubblePoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k,p,l){var n=this&&this.__extends||function(){var c=function(d,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,
b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return c(d,b)};return function(d,b){function a(){this.constructor=d}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");c(d,b);d.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),h=p.seriesTypes,d=h.map.prototype,y=h.mappoint.prototype;h=l.extend;var r=l.merge;l=function(g){function h(){var b=null!==g&&g.apply(this,arguments)||this;b.data=
void 0;b.options=void 0;b.points=void 0;b.clearBounds=d.clearBounds;return b}n(h,g);h.prototype.searchPoint=function(b,a){return this.searchKDTree({clientX:b.chartX-this.chart.plotLeft,plotY:b.chartY-this.chart.plotTop},a,b)};h.prototype.translate=function(){y.translate.call(this);this.getRadii();this.translateBubble()};h.defaultOptions=r(c.defaultOptions,{lineWidth:0,animationLimit:500,joinBy:"hc-key",tooltip:{pointFormat:"{point.name}: {point.z}"}});return h}(c);h(l.prototype,{type:"mapbubble",
axisTypes:["colorAxis"],getProjectedBounds:d.getProjectedBounds,isCartesian:!1,pointArrayMap:["z"],pointClass:k,processData:d.processData,projectPoint:y.projectPoint,setData:d.setData,setOptions:d.setOptions,updateData:d.updateData,useMapGeometry:!0,xyFromShape:!0});p.registerSeriesType("mapbubble",l);"";return l});z(c,"Series/Heatmap/HeatmapPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,k){var p=this&&this.__extends||function(){var c=function(d,g){c=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(c,b){c.__proto__=b}||function(c,b){for(var a in b)Object.prototype.hasOwnProperty.call(b,a)&&(c[a]=b[a])};return c(d,g)};return function(d,g){function h(){this.constructor=d}if("function"!==typeof g&&null!==g)throw new TypeError("Class extends value "+String(g)+" is not a constructor or null");c(d,g);d.prototype=null===g?Object.create(g):(h.prototype=g.prototype,new h)}}(),l=k.clamp,n=k.defined,h=k.extend,d=k.pick;c=function(c){function h(){var d=null!==c&&
c.apply(this,arguments)||this;d.options=void 0;d.series=void 0;d.value=void 0;d.x=void 0;d.y=void 0;return d}p(h,c);h.prototype.applyOptions=function(d,h){(this.isNull||null===this.value)&&delete this.color;c.prototype.applyOptions.call(this,d,h);this.formatPrefix=this.isNull||null===this.value?"null":"point";return this};h.prototype.getCellAttributes=function(){var c=this.series,h=c.options,b=(h.colsize||1)/2,a=(h.rowsize||1)/2,e=c.xAxis,k=c.yAxis,p=this.options.marker||c.options.marker;c=c.pointPlacementToXValue();
var m=d(this.pointPadding,h.pointPadding,0),r={x1:l(Math.round(e.len-e.translate(this.x-b,!1,!0,!1,!0,-c)),-e.len,2*e.len),x2:l(Math.round(e.len-e.translate(this.x+b,!1,!0,!1,!0,-c)),-e.len,2*e.len),y1:l(Math.round(k.translate(this.y-a,!1,!0,!1,!0)),-k.len,2*k.len),y2:l(Math.round(k.translate(this.y+a,!1,!0,!1,!0)),-k.len,2*k.len)};[["width","x"],["height","y"]].forEach(function(a){var b=a[0];a=a[1];var c=a+"1",d=a+"2",e=Math.abs(r[c]-r[d]),g=p&&p.lineWidth||0,h=Math.abs(r[c]+r[d])/2;b=p&&p[b];n(b)&&
b<e&&(b=b/2+g/2,r[c]=h-b,r[d]=h+b);m&&("y"===a&&(c=d,d=a+"1"),r[c]+=m,r[d]-=m)});return r};h.prototype.haloPath=function(c){if(!c)return[];var d=this.shapeArgs||{},b=d.x;b=void 0===b?0:b;var a=d.y;a=void 0===a?0:a;var e=d.width;e=void 0===e?0:e;d=d.height;d=void 0===d?0:d;return[["M",b-c,a-c],["L",b-c,a+d+c],["L",b+e+c,a+d+c],["L",b+e+c,a-c],["Z"]]};h.prototype.isValid=function(){return Infinity!==this.value&&-Infinity!==this.value};return h}(c.seriesTypes.scatter.prototype.pointClass);h(c.prototype,
{dataLabelOnNull:!0,moveToTopOnHover:!0,ttBelow:!1});return c});z(c,"Series/Heatmap/HeatmapSeries.js",[c["Core/Color/Color.js"],c["Series/ColorMapComposition.js"],c["Series/Heatmap/HeatmapPoint.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,k,p,l,n,h,d){var y=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,
b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),r=n.series,g=n.seriesTypes,v=g.column,b=g.scatter,a=h.prototype.symbols;h=d.extend;var e=d.fireEvent,q=d.isNumber,t=d.merge,m=d.pick;d=function(d){function g(){var a=
null!==d&&d.apply(this,arguments)||this;a.colorAxis=void 0;a.data=void 0;a.options=void 0;a.points=void 0;a.valueMax=NaN;a.valueMin=NaN;return a}y(g,d);g.prototype.drawPoints=function(){var a=this;if((this.options.marker||{}).enabled||this._hasPointMarkers)r.prototype.drawPoints.call(this),this.points.forEach(function(b){b.graphic&&(b.graphic[a.chart.styledMode?"css":"animate"](a.colorAttribs(b)),null===b.value&&b.graphic.addClass("highcharts-null-point"))})};g.prototype.getExtremes=function(){var a=
r.prototype.getExtremes.call(this,this.valueData),b=a.dataMin;a=a.dataMax;q(b)&&(this.valueMin=b);q(a)&&(this.valueMax=a);return r.prototype.getExtremes.call(this)};g.prototype.getValidPoints=function(a,b){return r.prototype.getValidPoints.call(this,a,b,!0)};g.prototype.hasData=function(){return!!this.processedXData.length};g.prototype.init=function(){d.prototype.init.apply(this,arguments);var b=this.options;b.pointRange=m(b.pointRange,b.colsize||1);this.yAxis.axisPointRange=b.rowsize||1;a.ellipse=
a.circle;b.marker&&(b.marker.r=b.borderRadius)};g.prototype.markerAttribs=function(a,b){var c=a.shapeArgs||{};if(a.hasImage)return{x:a.plotX,y:a.plotY};if(b&&"normal"!==b){var d=a.options.marker||{};a=this.options.marker||{};a=a.states&&a.states[b]||{};d=d.states&&d.states[b]||{};b=(d.width||a.width||c.width||0)+(d.widthPlus||a.widthPlus||0);a=(d.height||a.height||c.height||0)+(d.heightPlus||a.heightPlus||0);return{x:(c.x||0)+((c.width||0)-b)/2,y:(c.y||0)+((c.height||0)-a)/2,width:b,height:a}}return c};
g.prototype.pointAttribs=function(a,b){var d=r.prototype.pointAttribs.call(this,a,b),e=this.options||{},f=this.chart.options.plotOptions||{},g=f.series||{},h=f.heatmap||{};f=a&&a.options.borderColor||e.borderColor||h.borderColor||g.borderColor;g=a&&a.options.borderWidth||e.borderWidth||h.borderWidth||g.borderWidth||d["stroke-width"];d.stroke=a&&a.marker&&a.marker.lineColor||e.marker&&e.marker.lineColor||f||this.color;d["stroke-width"]=g;b&&"normal"!==b&&(a=t(e.states&&e.states[b],e.marker&&e.marker.states&&
e.marker.states[b],a&&a.options.states&&a.options.states[b]||{}),d.fill=a.color||c.parse(d.fill).brighten(a.brightness||0).get(),d.stroke=a.lineColor||d.stroke);return d};g.prototype.translate=function(){var b=this.options,c=b.marker&&b.marker.symbol||"rect",d=a[c]?c:"rect",g=-1!==["circle","square"].indexOf(d);this.generatePoints();this.points.forEach(function(e){var f=e.getCellAttributes(),h=Math.min(f.x1,f.x2),k=Math.min(f.y1,f.y2),l=Math.max(Math.abs(f.x2-f.x1),0),m=Math.max(Math.abs(f.y2-f.y1),
0);e.hasImage=0===(e.marker&&e.marker.symbol||c||"").indexOf("url");g&&(k=Math.abs(l-m),h=Math.min(f.x1,f.x2)+(l<m?0:k/2),k=Math.min(f.y1,f.y2)+(l<m?k/2:0),l=m=Math.min(l,m));e.hasImage&&(e.marker={width:l,height:m});e.plotX=e.clientX=(f.x1+f.x2)/2;e.plotY=(f.y1+f.y2)/2;e.shapeType="path";e.shapeArgs=t(!0,{x:h,y:k,width:l,height:m},{d:a[d](h,k,l,m,{r:b.borderRadius})})});e(this,"afterTranslate")};g.defaultOptions=t(b.defaultOptions,{animation:!1,borderRadius:0,borderWidth:0,nullColor:"#f7f7f7",dataLabels:{formatter:function(){var a=
this.series.chart.numberFormatter,b=this.point.value;return q(b)?a(b,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:"allow",padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}});return g}(b);h(d.prototype,{axisTypes:k.seriesMembers.axisTypes,colorKey:k.seriesMembers.colorKey,directTouch:!0,getExtremesFromAll:!0,
parallelArrays:k.seriesMembers.parallelArrays,pointArrayMap:["y","value"],pointClass:p,specialGroup:"group",trackerGroups:k.seriesMembers.trackerGroups,alignDataLabel:v.prototype.alignDataLabel,colorAttribs:k.seriesMembers.colorAttribs,drawLegendSymbol:l.drawRectangle,getSymbol:r.prototype.getSymbol});k.compose(d);n.registerSeriesType("heatmap",d);"";"";return d});z(c,"masters/modules/map.src.js",[c["Core/Globals.js"],c["Core/Axis/Color/ColorAxis.js"],c["Series/MapBubble/MapBubbleSeries.js"],c["Core/Chart/MapChart.js"],
c["Maps/MapView.js"],c["Maps/Projection.js"]],function(c,k,p,l,n,h){c.ColorAxis=k;c.MapChart=l;c.mapChart=c.Map=l.mapChart;c.MapView=n;c.maps=l.maps;c.Projection=h;k.compose(c.Chart,c.Fx,c.Legend,c.Series);p.compose(c.Axis,c.Chart,c.Legend,c.Series)})});
//# sourceMappingURL=map.js.map