<?php
    $user_role = auth()->user()->role;
    $admin  = 1;
?>

<!-- begin: Btn View profile Row -->
<?php if(auth()->user()->can('view-branches') || $user_role == $admin): ?>
    <a
        href="<?php echo e(fr_route('branches.show', $model->id)); ?>"
        class="btn btn-sm btn-secondary btn-action-table"
        data-toggle="tooltip" title="<?php echo e(__('view.view_profile')); ?>"
        >
        <i class="fas fa-eye fa-fw"></i>
    </a>
<?php endif; ?>
<!-- end: Btn View profile Row -->


<!-- begin: Btn Edit Row -->
<?php if(auth()->user()->can('edit-branches') || $user_role == $admin): ?>
    <a
        href="<?php echo e(fr_route('branches.edit', $model->id)); ?>"
        class="btn btn-sm btn-secondary btn-action-table"
        data-toggle="tooltip" title="<?php echo e(__('view.edit')); ?>"
        >
        <i class="fas fa-edit fa-fw"></i>
    </a>
<?php endif; ?>
<!-- end: Btn Edit Row -->

<!-- begin: Btn Delete Row -->
<?php if(auth()->user()->can('delete-branches') || $user_role == $admin): ?>
    <button
        type="button"
        data-action="<?php echo e(fr_route('branches.destroy', $model->id)); ?>"
        data-callback="reload-table"
        data-table-id="<?php echo e(isset($table_id) ? $table_id : ''); ?>"
        data-model-name="<?php echo e($model->name); ?>"
        data-modal-message="<?php echo app('translator')->get('view.modal_message_delete'); ?>"
        data-modal-action="<?php echo app('translator')->get('view.delete'); ?>"
        data-time-alert="2000"
        class="delete-row btn btn-sm btn-secondary btn-action-table btn-custom"
        data-toggle="tooltip" title="<?php echo e(__('view.delete')); ?>"
    >
        <i class="fas fa-trash fa-fw"></i>
    </button>
<?php endif; ?>


<!-- end: Btn Delete Row --><?php /**PATH C:\laragon\www\cargo\Modules/Cargo\Resources/views/adminLte/pages/branches/columns/actions.blade.php ENDPATH**/ ?>