/*
 Highstock JS v10.3.3 (2023-01-20)

 All technical indicators for Highcharts Stock

 (c) 2010-2021 Pawel Fus

 License: www.highcharts.com/license
*/
(function(f){"object"===typeof module&&module.exports?(f["default"]=f,module.exports=f):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(v){f(v);f.Highcharts=v;return f}):f("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(f){function v(f,e,g,k){f.hasOwnProperty(e)||(f[e]=k.apply(null,g),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:f[e]}})))}
f=f?f._modules:{};v(f,"Stock/Indicators/SMA/SMAIndicator.js",[f["Core/Chart/Chart.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function p(){this.constructor=c}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+
String(b)+" is not a constructor or null");a(c,b);c.prototype=null===b?Object.create(b):(p.prototype=b.prototype,new p)}}(),m=e.seriesTypes.line,q=g.addEvent,l=g.error,h=g.extend,d=g.isArray,a=g.merge,b=g.pick,c=g.splat;g=function(p){function u(){var a=null!==p&&p.apply(this,arguments)||this;a.data=void 0;a.dataEventsToUnbind=void 0;a.linkedParent=void 0;a.options=void 0;a.points=void 0;return a}k(u,p);u.prototype.destroy=function(){this.dataEventsToUnbind.forEach(function(a){a()});p.prototype.destroy.apply(this,
arguments)};u.prototype.getName=function(){var a=[],c=this.name;c||((this.nameComponents||[]).forEach(function(c,p){a.push(this.options.params[c]+b(this.nameSuffixes[p],""))},this),c=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+a.join(", ")+")":""));return c};u.prototype.getValues=function(a,c){var b=c.period,p=a.xData;a=a.yData;var u=a.length,C=[],h=[],w=[],e=-1,g=0,f=0;if(!(p.length<b)){for(d(a[0])&&(e=c.index?c.index:0);g<b-1;)f+=0>e?a[g]:a[g][e],g++;for(c=g;c<u;c++){f+=0>
e?a[c]:a[c][e];var l=[p[c],f/b];C.push(l);h.push(l[0]);w.push(l[1]);f-=0>e?a[c-g]:a[c-g][e]}return{values:C,xData:h,yData:w}}};u.prototype.init=function(a,c){var b=this;p.prototype.init.call(b,a,c);c=q(f,"afterLinkSeries",function(){var c=!!b.dataEventsToUnbind.length;if(b.linkedParent)if(c||(b.dataEventsToUnbind.push(q(b.linkedParent,"updatedData",function(){b.recalculateValues()})),b.calculateOn.xAxis&&b.dataEventsToUnbind.push(q(b.linkedParent.xAxis,b.calculateOn.xAxis,function(){b.recalculateValues()}))),
"init"===b.calculateOn.chart)b.processedYData||b.recalculateValues();else{if(!c)var p=q(b.chart,b.calculateOn.chart,function(){b.recalculateValues();p()})}else return l("Series "+b.options.linkedTo+" not found! Check `linkedTo`.",!1,a)},{order:0});b.dataEventsToUnbind=[];b.eventsToUnbind.push(c)};u.prototype.recalculateValues=function(){var a=[],b=this.points||[],p=(this.xData||[]).length,d={values:[],xData:[],yData:[]},u=!0;d=this.linkedParent.options&&this.linkedParent.yData&&this.linkedParent.yData.length?
this.getValues(this.linkedParent,this.options.params)||d:d;if(p&&!this.hasGroupedData&&this.visible&&this.points)if(this.cropped){if(this.xAxis){var h=this.xAxis.min;var x=this.xAxis.max}p=this.cropData(d.xData,d.yData,h,x);for(h=0;h<p.xData.length;h++)a.push([p.xData[h]].concat(c(p.yData[h])));p=d.xData.indexOf(this.xData[0]);h=d.xData.indexOf(this.xData[this.xData.length-1]);-1===p&&h===d.xData.length-2&&a[0][0]===b[0].x&&a.shift();this.updateData(a)}else d.xData.length!==p-1&&d.xData.length!==
p+1&&(u=!1,this.updateData(d.values));u&&(this.xData=d.xData,this.yData=d.yData,this.options.data=d.values);this.calculateOn.xAxis&&this.processedXData&&(delete this.processedXData,this.isDirty=!0,this.redraw());this.isDirtyData=!!this.linkedSeries};u.prototype.processData=function(){var a=this.options.compareToMain,c=this.linkedParent;p.prototype.processData.apply(this,arguments);this.dataModify&&c&&c.dataModify&&c.dataModify.compareValue&&a&&(this.dataModify.compareValue=c.dataModify.compareValue)};
u.defaultOptions=a(m.defaultOptions,{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:3,period:14}});return u}(m);h(g.prototype,{calculateOn:{chart:"init"},hasDerivedData:!0,nameComponents:["period"],nameSuffixes:[],useCommonDataGrouping:!0});e.registerSeriesType("sma",g);"";return g});v(f,"Stock/Indicators/EMA/EMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=function(d,a){h=
Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.sma,m=e.correctFloat,q=e.isArray,l=e.merge;e=
function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.accumulatePeriodPoints=function(a,b,c){for(var p=0,d=0,h;d<a;)h=0>b?c[d]:c[d][b],p+=h,d++;return p};d.prototype.calculateEma=function(a,b,c,p,d,h,w){a=a[c-1];b=0>h?b[c-1]:b[c-1][h];p="undefined"===typeof d?w:m(b*p+d*(1-p));return[a,p]};d.prototype.getValues=function(a,b){var c=b.period,p=a.xData,d=(a=a.yData)?a.length:0,h=2/(c+1),w=[],e=[],g=[],t=-1;if(!(d<
c)){q(a[0])&&(t=b.index?b.index:0);b=this.accumulatePeriodPoints(c,t,a);for(b/=c;c<d+1;c++){var n=this.calculateEma(p,a,c,h,n,t,b);w.push(n);e.push(n[0]);g.push(n[1]);n=n[1]}return{values:w,xData:e,yData:g}}};d.defaultOptions=l(k.defaultOptions,{params:{index:3,period:9}});return d}(k);f.registerSeriesType("ema",e);"";return e});v(f,"Stock/Indicators/AD/ADIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=function(d,
a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.sma,m=e.error,q=e.extend,l=e.merge;e=function(h){function d(){var a=
null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.populateAverage=function(a,b,c,p,d){d=b[p][1];var u=b[p][2];b=b[p][3];c=c[p];return[a[p],b===d&&b===u||d===u?0:(2*b-u-d)/(d-u)*c]};d.prototype.getValues=function(a,b){var c=b.period,p=a.xData,u=a.yData,h=b.volumeSeriesID,w=a.chart.get(h);b=w&&w.yData;var e=u?u.length:0,g=[],t=[],n=[];if(!(p.length<=c&&e&&4!==u[0].length)){if(w){for(h=c;h<e;h++)a=g.length,w=d.populateAverage(p,u,b,h,c),0<a&&(w[1]+=
g[a-1][1]),g.push(w),t.push(w[0]),n.push(w[1]);return{values:g,xData:t,yData:n}}m("Series "+h+" not found! Check `volumeSeriesID`.",!0,a.chart)}};d.defaultOptions=l(k.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}});return d}(k);q(e.prototype,{nameComponents:!1,nameBase:"Accumulation/Distribution"});f.registerSeriesType("ad",e);"";return e});v(f,"Stock/Indicators/AO/AOIndicator.js",[f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=
this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function p(){this.constructor=c}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");a(c,b);c.prototype=null===b?Object.create(b):(p.prototype=b.prototype,new p)}}();f=f.noop;
var m=e.seriesTypes,q=m.column.prototype,l=m.sma;m=g.extend;var h=g.merge,d=g.correctFloat,a=g.isArray;g=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(c,b);c.prototype.drawGraph=function(){var a=this.options,c=this.points,b=a.greaterBarColor;a=a.lowerBarColor;var d=c[0];if(!this.userOptions.color&&d)for(d.color=b,d=1;d<c.length;d++)c[d].color=c[d].y>c[d-1].y?b:c[d].y<c[d-1].y?a:c[d-1].color};c.prototype.getValues=function(c){var b=
c.xData||[];c=c.yData||[];var p=c.length,h=[],e=[],g=[],t=0,n=0,x;if(!(34>=b.length)&&a(c[0])&&4===c[0].length){for(x=0;33>x;x++){var r=(c[x][1]+c[x][2])/2;29<=x&&(t=d(t+r));n=d(n+r)}for(x=33;x<p;x++){r=(c[x][1]+c[x][2])/2;t=d(t+r);n=d(n+r);r=t/5;var B=n/34;r=d(r-B);h.push([b[x],r]);e.push(b[x]);g.push(r);r=x+1-5;B=x+1-34;t=d(t-(c[r][1]+c[r][2])/2);n=d(n-(c[B][1]+c[B][2])/2)}return{values:h,xData:e,yData:g}}};c.defaultOptions=h(l.defaultOptions,{params:{index:void 0,period:void 0},greaterBarColor:"#06b535",
lowerBarColor:"#f21313",threshold:0,groupPadding:.2,pointPadding:.2,crisp:!1,states:{hover:{halo:{size:0}}}});return c}(l);m(g.prototype,{nameBase:"AO",nameComponents:!1,markerAttribs:f,getColumnMetrics:q.getColumnMetrics,crispCol:q.crispCol,translate:q.translate,drawPoints:q.drawPoints});e.registerSeriesType("ao",g);"";return g});v(f,"Stock/Indicators/MultipleLinesComposition.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=f.seriesTypes.sma.prototype,k=e.defined,
m=e.error,q=e.merge,l;(function(h){function d(a){return"plot"+a.charAt(0).toUpperCase()+a.slice(1)}function a(a,c){var b=[];(a.pointArrayMap||[]).forEach(function(a){a!==c&&b.push(d(a))});return b}function b(){var c=this,b=c.linesApiNames,p=c.areaLinesNames,u=c.points,h=c.options,e=c.graph,C={options:{gapSize:h.gapSize}},w=[],y=a(c,c.pointValKey),f=u.length,O;y.forEach(function(c,a){for(w[a]=[];f--;)O=u[f],w[a].push({x:O.x,plotX:O.plotX,plotY:O[c],isNull:!k(O[c])});f=u.length});if(c.userOptions.fillColor&&
p.length){var l=y.indexOf(d(p[0]));l=w[l];p=1===p.length?u:w[y.indexOf(d(p[1]))];y=c.color;c.points=p;c.nextPoints=l;c.color=c.userOptions.fillColor;c.options=q(u,C);c.graph=c.area;c.fillGraph=!0;g.drawGraph.call(c);c.area=c.graph;delete c.nextPoints;delete c.fillGraph;c.color=y}b.forEach(function(a,b){w[b]?(c.points=w[b],h[a]?c.options=q(h[a].styles,C):m('Error: "There is no '+a+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names."'),c.graph=c["graph"+a],g.drawGraph.call(c),
c["graph"+a]=c.graph):m('Error: "'+a+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});c.points=u;c.options=h;c.graph=e;g.drawGraph.call(c)}function c(c){var a,b=[];c=c||this.points;if(this.fillGraph&&this.nextPoints){if((a=g.getGraphPath.call(this,this.nextPoints))&&a.length){a[0][0]="L";b=g.getGraphPath.call(this,c);a=a.slice(0,b.length);for(var p=a.length-1;0<=p;p--)b.push(a[p])}}else b=g.getGraphPath.apply(this,arguments);return b}function p(c){var a=
[];(this.pointArrayMap||[]).forEach(function(b){a.push(c[b])});return a}function u(){var c=this,b=this.pointArrayMap,p=[],d;p=a(this);g.translate.apply(this,arguments);this.points.forEach(function(a){b.forEach(function(b,u){d=a[b];c.dataModify&&(d=c.dataModify.modifyValue(d));null!==d&&(a[p[u]]=c.yAxis.toPixels(d,!0))})})}var e=[],w=["bottomLine"],y=["top","bottom"],f=["top"];h.compose=function(a){if(-1===e.indexOf(a)){e.push(a);var d=a.prototype;d.linesApiNames=d.linesApiNames||w.slice();d.pointArrayMap=
d.pointArrayMap||y.slice();d.pointValKey=d.pointValKey||"top";d.areaLinesNames=d.areaLinesNames||f.slice();d.drawGraph=b;d.getGraphPath=c;d.toYData=p;d.translate=u}return a}})(l||(l={}));return l});v(f,"Stock/Indicators/Aroon/AroonIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){function k(a,b){var c=a[0],p=0,d;for(d=1;d<a.length;d++)if("max"===b&&a[d]>=c||"min"===b&&a[d]<=c)c=a[d],p=d;return p}var m=this&&
this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)Object.prototype.hasOwnProperty.call(a,b)&&(c[b]=a[b])};return a(b,c)};return function(b,c){function p(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(p.prototype=c.prototype,new p)}}(),q=e.seriesTypes.sma,
l=g.extend,h=g.merge,d=g.pick;g=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}m(b,a);b.prototype.getValues=function(c,a){a=a.period;var b=c.xData,p=(c=c.yData)?c.length:0,h=[],e=[],g=[],t;for(t=a-1;t<p;t++){var n=c.slice(t-a+1,t+2);var x=k(n.map(function(a){return d(a[2],a)}),"min");n=k(n.map(function(a){return d(a[1],a)}),"max");n=n/a*100;x=x/a*100;b[t+1]&&(h.push([b[t+1],n,x]),e.push(b[t+1]),g.push([n,x]))}return{values:h,
xData:e,yData:g}};b.defaultOptions=h(q.defaultOptions,{params:{index:void 0,period:25},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}});return b}(q);l(g.prototype,{areaLinesNames:[],linesApiNames:["aroonDown"],nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y"});f.compose(g);
e.registerSeriesType("aroon",g);"";return g});v(f,"Stock/Indicators/AroonOscillator/AroonOscillatorIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return h(d,a)};return function(d,
a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=e.seriesTypes.aroon,q=g.extend,l=g.merge;g=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(d,h);d.prototype.getValues=function(a,b){var c=[],p=[],d=[];a=h.prototype.getValues.call(this,
a,b);for(b=0;b<a.yData.length;b++){var e=a.yData[b][0];var w=a.yData[b][1];e-=w;c.push([a.xData[b],e]);p.push(a.xData[b]);d.push(e)}return{values:c,xData:p,yData:d}};d.defaultOptions=l(m.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}});return d}(m);q(g.prototype,{nameBase:"Aroon Oscillator",linesApiNames:[],pointArrayMap:["y"],pointValKey:"y"});f.compose(m);e.registerSeriesType("aroonoscillator",g);"";return g});v(f,"Stock/Indicators/ATR/ATRIndicator.js",
[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function g(h,d){return Math.max(h[1]-h[2],"undefined"===typeof d?0:Math.abs(h[1]-d[3]),"undefined"===typeof d?0:Math.abs(h[2]-d[3]))}var k=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=
d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,q=e.isArray,l=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}k(d,h);d.prototype.getValues=function(a,b){b=b.period;var c=a.xData,p=(a=a.yData)?a.length:0,d=1,h=0,e=0,y=[],f=[],t=[],n;var x=
[[c[0],a[0]]];if(!(c.length<=b)&&q(a[0])&&4===a[0].length){for(n=1;n<=p;n++)if(x.push([c[n],a[n]]),b<d){var r=b;var B=c[n-1],l=g(a[n-1],a[n-2]);r=[B,(h*(r-1)+l)/r];h=r[1];y.push(r);f.push(r[0]);t.push(r[1])}else b===d?(h=e/(n-1),y.push([c[n-1],h]),f.push(c[n-1]),t.push(h)):e+=g(a[n-1],a[n-2]),d++;return{values:y,xData:f,yData:t}}};d.defaultOptions=l(m.defaultOptions,{params:{index:void 0}});return d}(m);f.registerSeriesType("atr",e);"";return e});v(f,"Stock/Indicators/BB/BBIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],
f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");d(a,b);
a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),m=e.seriesTypes.sma,q=g.extend,l=g.isArray,h=g.merge;g=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(a,d);a.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=h({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};a.prototype.getValues=function(a,c){var b=
c.period,d=c.standardDeviation,h=a.xData,w=(a=a.yData)?a.length:0,y=[],g=[],t=[],n;if(!(h.length<b)){var x=l(a[0]);for(n=b;n<=w;n++){var r=h.slice(n-b,n);var B=a.slice(n-b,n);var f=e.seriesTypes.sma.prototype.getValues.call(this,{xData:r,yData:B},c);r=f.xData[0];f=f.yData[0];for(var k=0,m=B.length,q=0;q<m;q++){var z=(x?B[q][c.index]:B[q])-f;k+=z*z}z=Math.sqrt(k/(m-1));B=f+d*z;z=f-d*z;y.push([r,B,f,z]);g.push(r);t.push([B,f,z])}return{values:y,xData:g,yData:t}}};a.defaultOptions=h(m.defaultOptions,
{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"}});return a}(m);q(g.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameComponents:["period",
"standardDeviation"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});f.compose(g);e.registerSeriesType("bb",g);"";return g});v(f,"Stock/Indicators/CCI/CCIIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function g(h){return h.reduce(function(d,a){return d+a},0)}var k=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,
b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,q=e.isArray,l=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}k(d,h);d.prototype.getValues=function(a,b){b=
b.period;var c=a.xData,p=(a=a.yData)?a.length:0,d=[],h=[],e=[],y=[],f=1;if(!(c.length<=b)&&q(a[0])&&4===a[0].length){for(;f<b;){var t=a[f-1];d.push((t[1]+t[2]+t[3])/3);f++}for(f=b;f<=p;f++){t=a[f-1];t=(t[1]+t[2]+t[3])/3;var n=d.push(t);var x=d.slice(n-b);n=g(x)/b;var r,B=x.length,l=0;for(r=0;r<B;r++)l+=Math.abs(n-x[r]);x=l/b;t=(t-n)/(.015*x);h.push([c[f-1],t]);e.push(c[f-1]);y.push(t)}return{values:h,xData:e,yData:y}}};d.defaultOptions=l(m.defaultOptions,{params:{index:void 0}});return d}(m);f.registerSeriesType("cci",
e);"";return e});v(f,"Stock/Indicators/CMF/CMFIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,h){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,a){d.__proto__=a}||function(d,a){for(var b in a)Object.prototype.hasOwnProperty.call(a,b)&&(d[b]=a[b])};return e(f,h)};return function(f,h){function d(){this.constructor=f}if("function"!==typeof h&&null!==h)throw new TypeError("Class extends value "+
String(h)+" is not a constructor or null");e(f,h);f.prototype=null===h?Object.create(h):(d.prototype=h.prototype,new d)}}(),k=f.seriesTypes.sma,m=e.merge;e=function(e){function f(){var h=null!==e&&e.apply(this,arguments)||this;h.data=void 0;h.options=void 0;h.points=void 0;h.volumeSeries=void 0;h.linkedParent=void 0;h.yData=void 0;h.nameBase="Chaikin Money Flow";return h}g(f,e);f.prototype.isValid=function(){var h=this.chart,d=this.options,a=this.linkedParent;h=this.volumeSeries||(this.volumeSeries=
h.get(d.params.volumeSeriesID));var b=a&&a.yData&&4===a.yData[0].length;return!!(a&&h&&a.xData&&a.xData.length>=d.params.period&&h.xData&&h.xData.length>=d.params.period&&b)};f.prototype.getValues=function(h,d){if(this.isValid())return this.getMoneyFlow(h.xData,h.yData,this.volumeSeries.yData,d.period)};f.prototype.getMoneyFlow=function(h,d,a,b){function c(a,c){var b=a[1],p=a[2];a=a[3];return null!==c&&null!==b&&null!==p&&null!==a&&b!==p?(a-p-(b-a))/(b-p)*c:(x=n,null)}var p=d.length,u=[],e=0,w=0,
y=[],f=[],t=[],n,x=-1;if(0<b&&b<=p){for(n=0;n<b;n++)u[n]=c(d[n],a[n]),e+=a[n],w+=u[n];y.push(h[n-1]);f.push(n-x>=b&&0!==e?w/e:null);for(t.push([y[0],f[0]]);n<p;n++){u[n]=c(d[n],a[n]);e-=a[n-b];e+=a[n];w-=u[n-b];w+=u[n];var r=[h[n],n-x>=b?w/e:null];y.push(r[0]);f.push(r[1]);t.push([r[0],r[1]])}}return{values:t,xData:y,yData:f}};f.defaultOptions=m(k.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}});return f}(k);f.registerSeriesType("cmf",e);"";return e});v(f,"Stock/Indicators/DMI/DMIIndicator.js",
[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function p(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+
String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(p.prototype=c.prototype,new p)}}(),m=e.seriesTypes.sma,q=g.correctFloat,l=g.extend,h=g.isArray,d=g.merge;g=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.options=void 0;return c}k(b,a);b.prototype.calculateDM=function(a,b,d){var c=a[b][1],p=a[b][2],u=a[b-1][1];a=a[b-1][2];return q(c-u>a-p?d?Math.max(c-u,0):0:d?0:Math.max(a-p,0))};b.prototype.calculateDI=function(a,b){return a/b*100};
b.prototype.calculateDX=function(a,b){return q(Math.abs(a-b)/Math.abs(a+b)*100)};b.prototype.smoothValues=function(a,b,d){return q(a-a/d+b)};b.prototype.getTR=function(a,b){return q(Math.max(a[1]-a[2],b?Math.abs(a[1]-b[3]):0,b?Math.abs(a[2]-b[3]):0))};b.prototype.getValues=function(a,b){b=b.period;var c=a.xData,p=(a=a.yData)?a.length:0,d=[],e=[],f=[];if(!(c.length<=b)&&h(a[0])&&4===a[0].length){var t=0,n=0,x=0,r;for(r=1;r<p;r++)if(r<=b){var g=this.calculateDM(a,r,!0);var l=this.calculateDM(a,r);var k=
this.getTR(a[r],a[r-1]);t+=g;n+=l;x+=k;r===b&&(k=this.calculateDI(t,x),l=this.calculateDI(n,x),g=this.calculateDX(t,n),d.push([c[r],g,k,l]),e.push(c[r]),f.push([g,k,l]))}else g=this.calculateDM(a,r,!0),l=this.calculateDM(a,r),k=this.getTR(a[r],a[r-1]),t=this.smoothValues(t,g,b),n=this.smoothValues(n,l,b),x=this.smoothValues(x,k,b),k=this.calculateDI(t,x),l=this.calculateDI(n,x),g=this.calculateDX(t,n),d.push([c[r],g,k,l]),e.push(c[r]),f.push([g,k,l]);return{values:d,xData:e,yData:f}}};b.defaultOptions=
d(m.defaultOptions,{params:{index:void 0},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">DX</span>: {point.y}<br/><span style="color: {point.series.options.plusDILine.styles.lineColor}">+DI</span>: {point.plusDI}<br/><span style="color: {point.series.options.minusDILine.styles.lineColor}">-DI</span>: {point.minusDI}<br/>'},plusDILine:{styles:{lineWidth:1,lineColor:"#06b535"}},minusDILine:{styles:{lineWidth:1,
lineColor:"#f21313"}},dataGrouping:{approximation:"averages"}});return b}(m);l(g.prototype,{areaLinesNames:[],nameBase:"DMI",linesApiNames:["plusDILine","minusDILine"],pointArrayMap:["y","plusDI","minusDI"],parallelArrays:["x","y","plusDI","minusDI"],pointValKey:"y"});f.compose(g);e.registerSeriesType("dmi",g);"";return g});v(f,"Stock/Indicators/DPO/DPOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function g(a,b,c,p,u){b=d(b[c][p],b[c]);return u?h(a-b):h(a+
b)}var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function p(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(p.prototype=c.prototype,new p)}}(),
m=f.seriesTypes.sma,q=e.extend,l=e.merge,h=e.correctFloat,d=e.pick;e=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.options=void 0;c.data=void 0;c.points=void 0;return c}k(b,a);b.prototype.getValues=function(a,b){var c=b.period;b=b.index;var p=c+Math.floor(c/2+1),h=a.xData||[];a=a.yData||[];var e=a.length,f=[],t=[],n=[],x,r,B=0;if(!(h.length<=p)){for(x=0;x<c-1;x++)B=g(B,a,x,b);for(r=0;r<=e-p;r++){var l=r+c-1;x=r+p-1;B=g(B,a,l,b);l=d(a[x][b],a[x]);l-=B/c;B=g(B,a,r,b,!0);f.push([h[x],
l]);t.push(h[x]);n.push(l)}return{values:f,xData:t,yData:n}}};b.defaultOptions=l(m.defaultOptions,{params:{index:0,period:21}});return b}(m);q(e.prototype,{nameBase:"DPO"});f.registerSeriesType("dpo",e);"";return e});v(f,"Stock/Indicators/Chaikin/ChaikinIndicator.js",[f["Stock/Indicators/AD/ADIndicator.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,
c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function p(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(p.prototype=c.prototype,new p)}}(),m=e.seriesTypes.ema,q=g.correctFloat,l=g.extend,h=g.merge,d=g.error;g=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||
this;c.data=void 0;c.options=void 0;c.points=void 0;return c}k(b,a);b.prototype.getValues=function(a,b){var c=b.periods,p=b.period,h=[],e=[],g=[],t;if(2!==c.length||c[1]<=c[0])d('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');else if(b=f.prototype.getValues.call(this,a,{volumeSeriesID:b.volumeSeriesID,period:p}))if(a=m.prototype.getValues.call(this,b,{period:c[0]}),b=m.prototype.getValues.call(this,b,{period:c[1]}),a&&b){c=c[1]-c[0];for(t=0;t<b.yData.length;t++)p=
q(a.yData[t+c]-b.yData[t]),h.push([b.xData[t],p]),e.push(b.xData[t]),g.push(p);return{values:h,xData:e,yData:g}}};b.defaultOptions=h(m.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",period:9,periods:[3,10]}});return b}(m);l(g.prototype,{nameBase:"Chaikin Osc",nameComponents:["periods"]});e.registerSeriesType("chaikin",g);"";return g});v(f,"Stock/Indicators/CMO/CMOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=
function(h,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return e(h,d)};return function(h,d){function a(){this.constructor=h}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");e(h,d);h.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=f.seriesTypes.sma,m=e.isNumber,q=e.merge;e=
function(e){function h(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(h,e);h.prototype.getValues=function(d,a){var b=a.period,c=d.xData,p=d.yData;d=p?p.length:0;var h=[],e=[],f=[],y,g=a.index;if(!(c.length<b)){m(p[0])?a=p:(g=Math.min(g,p[0].length-1),a=p.map(function(a){return a[g]}));var t=0,n=p=0;for(y=b;0<y;y--)a[y]>a[y-1]?p+=a[y]-a[y-1]:a[y]<a[y-1]&&(n+=a[y-1]-a[y]);t=0<p+n?100*(p-n)/(p+n):0;e.push(c[b]);f.push(t);h.push([c[b],t]);for(y=
b+1;y<d;y++)t=Math.abs(a[y-b-1]-a[y-b]),a[y]>a[y-1]?p+=a[y]-a[y-1]:a[y]<a[y-1]&&(n+=a[y-1]-a[y]),a[y-b]>a[y-b-1]?p-=t:n-=t,t=0<p+n?100*(p-n)/(p+n):0,e.push(c[y]),f.push(t),h.push([c[y],t]);return{values:h,xData:e,yData:f}}};h.defaultOptions=q(k.defaultOptions,{params:{period:20,index:3}});return h}(k);f.registerSeriesType("cmo",e);"";return e});v(f,"Stock/Indicators/DEMA/DEMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=
function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.ema,m=e.correctFloat,q=e.isArray,
l=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.getEMA=function(a,b,c,p,d,e){return h.prototype.calculateEma.call(this,e||[],a,"undefined"===typeof d?1:d,this.EMApercent,b,"undefined"===typeof p?-1:p,c)};d.prototype.getValues=function(a,b){var c=b.period,p=[],d=2*c,e=a.xData,f=(a=a.yData)?a.length:0,g=[],k=[],t=[],n=0,x,r=-1;this.EMApercent=2/(c+1);if(!(f<2*c-1)){q(a[0])&&
(r=b.index?b.index:0);b=h.prototype.accumulatePeriodPoints.call(this,c,r,a);var B=b/c;b=0;for(x=c;x<f+2;x++){x<f+1&&(n=this.getEMA(a,l,B,r,x)[1],p.push(n));var l=n;if(x<d)b+=n;else{x===d&&(B=b/c);n=p[x-c-1];var A=this.getEMA([n],A,B)[1];var z=[e[x-2],m(2*n-A)];g.push(z);k.push(z[0]);t.push(z[1])}}return{values:g,xData:k,yData:t}}};d.defaultOptions=l(k.defaultOptions);return d}(k);f.registerSeriesType("dema",e);"";return e});v(f,"Stock/Indicators/TEMA/TEMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");h(d,a);d.prototype=null===a?Object.create(a):
(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.ema,m=e.correctFloat,q=e.isArray,l=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.getEMA=function(a,b,c,d,h,e){return k.prototype.calculateEma(e||[],a,"undefined"===typeof h?1:h,this.EMApercent,b,"undefined"===typeof d?-1:d,c)};d.prototype.getTemaPoint=function(a,b,c,d){return[a[d-3],m(3*c.level1-3*c.level2+c.level3)]};
d.prototype.getValues=function(a,b){var c=b.period,d=2*c,h=3*c,e=a.xData,f=(a=a.yData)?a.length:0,g=-1,l=[],t=[],n=[],x=[],r=[],B,m,A={};this.EMApercent=2/(c+1);if(!(f<3*c-2)){q(a[0])&&(g=b.index?b.index:0);b=k.prototype.accumulatePeriodPoints(c,g,a);var z=b/c;b=0;for(B=c;B<f+3;B++){B<f+1&&(A.level1=this.getEMA(a,D,z,g,B)[1],x.push(A.level1));var D=A.level1;if(B<d)b+=A.level1;else{B===d&&(z=b/c,b=0);A.level1=x[B-c-1];A.level2=this.getEMA([A.level1],Q,z)[1];r.push(A.level2);var Q=A.level2;if(B<h)b+=
A.level2;else{B===h&&(z=b/c);B===f+1&&(A.level1=x[B-c-1],A.level2=this.getEMA([A.level1],Q,z)[1],r.push(A.level2));A.level1=x[B-c-2];A.level2=r[B-2*c-1];A.level3=this.getEMA([A.level2],A.prevLevel3,z)[1];if(m=this.getTemaPoint(e,h,A,B))l.push(m),t.push(m[0]),n.push(m[1]);A.prevLevel3=A.level3}}}return{values:l,xData:t,yData:n}}};d.defaultOptions=l(k.defaultOptions);return d}(k);f.registerSeriesType("tema",e);"";return e});v(f,"Stock/Indicators/TRIX/TRIXIndicator.js",[f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(h,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return e(h,d)};return function(h,d){function a(){this.constructor=h}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");e(h,d);h.prototype=null===d?Object.create(d):
(a.prototype=d.prototype,new a)}}(),k=f.seriesTypes.tema,m=e.correctFloat,q=e.merge;e=function(e){function h(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(h,e);h.prototype.getTemaPoint=function(d,a,b,c){if(c>a)return[d[c-3],0!==b.prevLevel3?m(b.level3-b.prevLevel3)/b.prevLevel3*100:null]};h.defaultOptions=q(k.defaultOptions);return h}(k);f.registerSeriesType("trix",e);"";return e});v(f,"Stock/Indicators/APO/APOIndicator.js",[f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");h(d,a);d.prototype=null===a?Object.create(a):
(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.ema,m=e.extend,q=e.merge,l=e.error;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.getValues=function(a,b){var c=b.periods,d=b.index;b=[];var h=[],e=[],f;if(2!==c.length||c[1]<=c[0])l('Error: "APO requires two periods. Notice, first period should be lower than the second one."');else{var g=k.prototype.getValues.call(this,a,{index:d,period:c[0]});a=
k.prototype.getValues.call(this,a,{index:d,period:c[1]});if(g&&a){c=c[1]-c[0];for(f=0;f<a.yData.length;f++)d=g.yData[f+c]-a.yData[f],b.push([a.xData[f],d]),h.push(a.xData[f]),e.push(d);return{values:b,xData:h,yData:e}}}};d.defaultOptions=q(k.defaultOptions,{params:{period:void 0,periods:[10,20]}});return d}(k);m(e.prototype,{nameBase:"APO",nameComponents:["periods"]});f.registerSeriesType("apo",e);"";return e});v(f,"Stock/Indicators/IKH/IKHIndicator.js",[f["Extensions/DataGrouping/ApproximationRegistry.js"],
f["Core/Color/Color.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g,k){function m(a){return a.reduce(function(a,b){return Math.max(a,b[1])},-Infinity)}function q(a){return a.reduce(function(a,b){return Math.min(a,b[2])},Infinity)}function l(a){return{high:m(a),low:q(a)}}function h(a){var b,c,d,p,h;a.series.forEach(function(a){if(a.xData)for(p=a.xData,h=c=a.xIncrement?1:p.length-1;0<h;h--)if(d=p[h]-p[h-1],"undefined"===typeof b||d<b)b=d});return b}function d(a,b,c,d){if(a&&
b&&c&&d){var p=b.plotX-a.plotX;b=b.plotY-a.plotY;var h=d.plotX-c.plotX;d=d.plotY-c.plotY;var e=a.plotX-c.plotX,u=a.plotY-c.plotY;c=(-b*e+p*u)/(-h*b+p*d);h=(h*u-d*e)/(-h*b+p*d);if(0<=c&&1>=c&&0<=h&&1>=h)return{plotX:a.plotX+h*p,plotY:a.plotY+h*b}}}function a(a){var b=a.indicator;b.points=a.points;b.nextPoints=a.nextPoints;b.color=a.color;b.options=y(a.options.senkouSpan.styles,a.gap);b.graph=a.graph;b.fillGraph=!0;g.seriesTypes.sma.prototype.drawGraph.call(b)}var b=this&&this.__extends||function(){var a=
function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),c=e.parse,p=g.seriesTypes.sma,u=k.defined;e=k.extend;
var C=k.isArray,w=k.isNumber,y=k.merge,O=k.objectEach;k=function(e){function f(){var a=null!==e&&e.apply(this,arguments)||this;a.data=[];a.options={};a.points=[];a.graphCollection=[];return a}b(f,e);f.prototype.init=function(){e.prototype.init.apply(this,arguments);this.options=y({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:c(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,
fill:c(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:c(this.color).setOpacity(.2).get()}}},this.options)};f.prototype.toYData=function(a){return[a.tenkanSen,a.kijunSen,a.chikouSpan,a.senkouSpanA,a.senkouSpanB]};f.prototype.translate=function(){g.seriesTypes.sma.prototype.translate.apply(this);for(var a=0,b=this.points;a<b.length;a++)for(var c=b[a],d=0,p=this.pointArrayMap;d<p.length;d++){var h=p[d],e=c[h];w(e)&&(c["plot"+h]=this.yAxis.toPixels(e,!0),c.plotY=c["plot"+h],c.tooltipPos=
[c.plotX,c["plot"+h]],c.isNull=!1)}};f.prototype.drawGraph=function(){var b=this,c=b.points,p=b.options,h=b.graph,e=b.color,f={options:{gapSize:p.gapSize}},w=b.pointArrayMap.length,t=[[],[],[],[],[],[]],n={tenkanLine:t[0],kijunLine:t[1],chikouLine:t[2],senkouSpanA:t[3],senkouSpanB:t[4],senkouSpan:t[5]},C=[],k=b.options.senkouSpan,l=k.color||k.styles.fill,m=k.negativeColor,q=[[],[]],z=[[],[]];k=c.length;var v=0,N,R,P;for(b.ikhMap=n;k--;){var G=c[k];for(N=0;N<w;N++){var H=b.pointArrayMap[N];u(G[H])&&
t[N].push({plotX:G.plotX,plotY:G["plot"+H],isNull:!1})}m&&k!==c.length-1&&(H=n.senkouSpanB.length-1,G=d(n.senkouSpanA[H-1],n.senkouSpanA[H],n.senkouSpanB[H-1],n.senkouSpanB[H]))&&(G={plotX:G.plotX,plotY:G.plotY,isNull:!1,intersectPoint:!0},n.senkouSpanA.splice(H,0,G),n.senkouSpanB.splice(H,0,G),C.push(H))}O(n,function(a,c){p[c]&&"senkouSpan"!==c&&(b.points=t[v],b.options=y(p[c].styles,f),b.graph=b["graph"+c],b.fillGraph=!1,b.color=e,g.seriesTypes.sma.prototype.drawGraph.call(b),b["graph"+c]=b.graph);
v++});if(b.graphCollection)for(w=0,k=b.graphCollection;w<k.length;w++)H=k[w],b[H].destroy(),delete b[H];b.graphCollection=[];if(m&&n.senkouSpanA[0]&&n.senkouSpanB[0]){C.unshift(0);C.push(n.senkouSpanA.length-1);for(k=0;k<C.length-1;k++){H=C[k];G=C[k+1];w=n.senkouSpanB.slice(H,G+1);H=n.senkouSpanA.slice(H,G+1);if(1<=Math.floor(w.length/2))if(G=Math.floor(w.length/2),w[G].plotY===H[G].plotY){for(P=N=G=0;P<w.length;P++)G+=w[P].plotY,N+=H[P].plotY;G=G>N?0:1}else G=w[G].plotY>H[G].plotY?0:1;else G=w[0].plotY>
H[0].plotY?0:1;q[G]=q[G].concat(w);z[G]=z[G].concat(H)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(c,d){q[d].length&&z[d].length&&(R=0===d?l:m,a({indicator:b,points:q[d],nextPoints:z[d],color:R,options:p,gap:f,graph:b[c]}),b[c]=b.graph,b.graphCollection.push(c))})}else a({indicator:b,points:n.senkouSpanB,nextPoints:n.senkouSpanA,color:l,options:p,gap:f,graph:b.graphsenkouSpan}),b.graphsenkouSpan=b.graph;delete b.nextPoints;delete b.fillGraph;b.points=c;b.options=p;b.graph=
h;b.color=e};f.prototype.getGraphPath=function(a){var b=[],c;a=a||this.points;if(this.fillGraph&&this.nextPoints){if((c=g.seriesTypes.sma.prototype.getGraphPath.call(this,this.nextPoints))&&c.length){c[0][0]="L";b=g.seriesTypes.sma.prototype.getGraphPath.call(this,a);c=c.slice(0,b.length);for(var d=c.length-1;0<=d;d--)b.push(c[d])}}else b=g.seriesTypes.sma.prototype.getGraphPath.apply(this,arguments);return b};f.prototype.getValues=function(a,b){var c=b.period,d=b.periodTenkan;b=b.periodSenkouSpanB;
var p=a.xData,e=a.yData,f=e&&e.length||0;a=h(a.xAxis);var u=[],w=[],g;if(!(p.length<=c)&&C(e[0])&&4===e[0].length){var n=p[0]-c*a;for(g=0;g<c;g++)w.push(n+g*a);for(g=0;g<f;g++){if(g>=d){var t=e.slice(g-d,g);t=l(t);t=(t.high+t.low)/2}if(g>=c){var y=e.slice(g-c,g);y=l(y);y=(y.high+y.low)/2;var r=(t+y)/2}if(g>=b){var k=e.slice(g-b,g);k=l(k);k=(k.high+k.low)/2}n=e[g][3];var x=p[g];"undefined"===typeof u[g]&&(u[g]=[]);"undefined"===typeof u[g+c-1]&&(u[g+c-1]=[]);u[g+c-1][0]=t;u[g+c-1][1]=y;u[g+c-1][2]=
void 0;"undefined"===typeof u[g+1]&&(u[g+1]=[]);u[g+1][2]=n;g<=c&&(u[g+c-1][3]=void 0,u[g+c-1][4]=void 0);"undefined"===typeof u[g+2*c-2]&&(u[g+2*c-2]=[]);u[g+2*c-2][3]=r;u[g+2*c-2][4]=k;w.push(x)}for(g=1;g<=c;g++)w.push(x+g*a);return{values:u,xData:w,yData:u}}};f.defaultOptions=y(p.defaultOptions,{params:{index:void 0,period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}});return f}(p);e(k.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB",
"period","periodTenkan"]});f["ichimoku-averages"]=function(){var a=[],b;[].forEach.call(arguments,function(c,d){a.push(f.average(c));b=!b&&"undefined"===typeof a[d]});return b?void 0:a};g.registerSeriesType("ikh",k);"";return k});v(f,"Stock/Indicators/KeltnerChannels/KeltnerChannelsIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),m=e.seriesTypes.sma,q=g.correctFloat,l=g.extend,h=g.merge;g=function(d){function a(){var a=
null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(a,d);a.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=h({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};a.prototype.getValues=function(a,c){var b=c.period,d=c.periodATR,h=c.multiplierATR,f=a.yData;f=f?f.length:0;var g=[];c=e.seriesTypes.ema.prototype.getValues(a,{period:b,index:c.index});var k=e.seriesTypes.atr.prototype.getValues(a,
{period:d}),t=[],n=[],x;if(!(f<b)){for(x=b;x<=f;x++){var r=c.values[x-b];var l=k.values[x-d];var m=r[0];a=q(r[1]+h*l[1]);l=q(r[1]-h*l[1]);r=r[1];g.push([m,a,r,l]);t.push(m);n.push([a,r,l])}return{values:g,xData:t,yData:n}}};a.defaultOptions=h(m.defaultOptions,{params:{index:0,period:20,periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},
marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1});return a}(m);l(g.prototype,{nameBase:"Keltner Channels",areaLinesNames:["top","bottom"],nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});f.compose(g);e.registerSeriesType("keltnerchannels",g);"";return g});v(f,"Stock/Indicators/Klinger/KlingerIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):
(d.prototype=c.prototype,new d)}}(),m=e.seriesTypes,q=m.ema,l=m.sma,h=g.correctFloat,d=g.error;m=g.extend;var a=g.isArray,b=g.merge;g=function(c){function p(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;a.volumeSeries=void 0;return a}k(p,c);p.prototype.calculateTrend=function(a,b){return a[b][1]+a[b][2]+a[b][3]>a[b-1][1]+a[b-1][2]+a[b-1][3]?1:-1};p.prototype.isValidData=function(b){var c=this.chart,p=this.options,h=this.linkedParent;b=a(b)&&4===b.length;
(c=this.volumeSeries||(this.volumeSeries=c.get(p.params.volumeSeriesID)))||d("Series "+p.params.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,h.chart);return!(![h,c].every(function(a){return a&&a.xData&&a.xData.length>=p.params.slowAvgPeriod})||!b)};p.prototype.getCM=function(a,b,c,d,p){return h(b+(c===d?a:p))};p.prototype.getDM=function(a,b){return h(a-b)};p.prototype.getVolumeForce=function(a){var b=[],c=1;var d=0;var p=a[0][1]-a[0][2];var h=0;for(c;c<a.length;c++){var e=this.calculateTrend(a,
c);var f=this.getDM(a[c][1],a[c][2]);d=this.getCM(d,f,e,h,p);h=this.volumeSeries.yData[c]*e*Math.abs(2*(f/d-1))*100;b.push([h]);h=e;p=f}return b};p.prototype.getEMA=function(a,b,c,d,p,h,e){return q.prototype.calculateEma(e||[],a,"undefined"===typeof h?1:h,d,b,"undefined"===typeof p?-1:p,c)};p.prototype.getSMA=function(a,b,c){return q.prototype.accumulatePeriodPoints(a,b,c)/a};p.prototype.getValues=function(a,b){var c=[],d=a.xData;a=a.yData;var p=[],e=[],f=[],g,u=0,k=0,l=void 0,C=void 0,m=null;if(this.isValidData(a[0])){var q=
this.getVolumeForce(a),z=this.getSMA(b.fastAvgPeriod,0,q),E=this.getSMA(b.slowAvgPeriod,0,q),F=2/(b.fastAvgPeriod+1),v=2/(b.slowAvgPeriod+1);for(u;u<a.length;u++)u>=b.fastAvgPeriod&&(l=k=this.getEMA(q,l,z,F,0,u,d)[1]),u>=b.slowAvgPeriod&&(C=g=this.getEMA(q,C,E,v,0,u,d)[1],g=h(k-g),f.push(g),f.length>=b.signalPeriod&&(m=f.slice(-b.signalPeriod).reduce(function(a,b){return a+b})/b.signalPeriod),c.push([d[u],g,m]),p.push(d[u]),e.push([g,m]));return{values:c,xData:p,yData:e}}};p.defaultOptions=b(l.defaultOptions,
{params:{fastAvgPeriod:34,slowAvgPeriod:55,signalPeriod:13,volumeSeriesID:"volume"},signalLine:{styles:{lineWidth:1,lineColor:"#ff0000"}},dataGrouping:{approximation:"averages"},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">Klinger</span>: {point.y}<br/><span style="color: {point.series.options.signalLine.styles.lineColor}">Signal</span>: {point.signal}<br/>'}});return p}(l);m(g.prototype,{areaLinesNames:[],linesApiNames:["signalLine"],
nameBase:"Klinger",nameComponents:["fastAvgPeriod","slowAvgPeriod"],pointArrayMap:["y","signal"],parallelArrays:["x","y","signal"],pointValKey:"y"});f.compose(g);e.registerSeriesType("klinger",g);"";return g});v(f,"Stock/Indicators/MACD/MACDIndicator.js",[f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,
b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,d)};return function(b,d){function c(){this.constructor=b}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),m=f.noop,q=e.seriesTypes.sma,l=g.extend,h=g.correctFloat,d=g.defined,a=g.merge;g=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=
void 0;a.options=void 0;a.points=void 0;a.currentLineZone=void 0;a.graphmacd=void 0;a.graphsignal=void 0;a.macdZones=void 0;a.signalZones=void 0;return a}k(c,b);c.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);var a=this.color,b=this.userOptions._colorIndex;this.options&&(d(this.userOptions._colorIndex)&&(this.options.signalLine&&this.options.signalLine.styles&&!this.options.signalLine.styles.lineColor&&(this.userOptions._colorIndex++,this.getCyclic("color",void 0,
this.chart.options.colors),this.options.signalLine.styles.lineColor=this.color),this.options.macdLine&&this.options.macdLine.styles&&!this.options.macdLine.styles.lineColor&&(this.userOptions._colorIndex++,this.getCyclic("color",void 0,this.chart.options.colors),this.options.macdLine.styles.lineColor=this.color)),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length},
this.resetZones=!0);this.color=a;this.userOptions._colorIndex=b};c.prototype.toYData=function(a){return[a.y,a.signal,a.MACD]};c.prototype.translate=function(){var a=this,b=["plotSignal","plotMACD"];f.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(c){[c.signal,c.MACD].forEach(function(d,p){null!==d&&(c[b[p]]=a.yAxis.toPixels(d,!0))})})};c.prototype.destroy=function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&
this.graphsignal.destroy();e.seriesTypes.sma.prototype.destroy.apply(this,arguments)};c.prototype.drawGraph=function(){for(var b=this,c=b.points,h=c.length,f=b.options,g=b.zones,k={options:{gapSize:f.gapSize}},t=[[],[]],n;h--;)n=c[h],d(n.plotMACD)&&t[0].push({plotX:n.plotX,plotY:n.plotMACD,isNull:!d(n.plotMACD)}),d(n.plotSignal)&&t[1].push({plotX:n.plotX,plotY:n.plotSignal,isNull:!d(n.plotMACD)});["macd","signal"].forEach(function(c,d){b.points=t[d];b.options=a(f[c+"Line"].styles,k);b.graph=b["graph"+
c];b.currentLineZone=c+"Zones";b.zones=b[b.currentLineZone].zones;e.seriesTypes.sma.prototype.drawGraph.call(b);b["graph"+c]=b.graph});b.points=c;b.options=f;b.zones=g;b.currentLineZone=null};c.prototype.getZonesGraphs=function(a){var c=b.prototype.getZonesGraphs.call(this,a),d=c;this.currentLineZone&&(d=c.splice(this[this.currentLineZone].startIndex+1),d.length?d.splice(0,0,a[0]):d=[a[0]]);return d};c.prototype.applyZones=function(){var a=this.zones;this.zones=this.signalZones.zones;e.seriesTypes.sma.prototype.applyZones.call(this);
this.graphmacd&&this.options.macdLine.zones.length&&this.graphmacd.hide();this.zones=a};c.prototype.getValues=function(a,b){var c=b.longPeriod-b.shortPeriod,p=0,f=[],g=[],u=[];if(!(a.xData.length<b.longPeriod+b.signalPeriod)){var n=e.seriesTypes.ema.prototype.getValues(a,{period:b.shortPeriod,index:b.index});var k=e.seriesTypes.ema.prototype.getValues(a,{period:b.longPeriod,index:b.index});n=n.values;k=k.values;for(a=0;a<=n.length;a++)d(k[a])&&d(k[a][1])&&d(n[a+c])&&d(n[a+c][0])&&f.push([n[a+c][0],
0,null,n[a+c][1]-k[a][1]]);for(a=0;a<f.length;a++)g.push(f[a][0]),u.push([0,null,f[a][3]]);b=e.seriesTypes.ema.prototype.getValues({xData:g,yData:u},{period:b.signalPeriod,index:2});b=b.values;for(a=0;a<f.length;a++)f[a][0]>=b[0][0]&&(f[a][2]=b[p][1],u[a]=[0,b[p][1],f[a][3]],null===f[a][3]?(f[a][1]=0,u[a][0]=0):(f[a][1]=h(f[a][3]-b[p][1]),u[a][0]=h(f[a][3]-b[p][1])),p++);return{values:f,xData:g,yData:u}}};c.defaultOptions=a(q.defaultOptions,{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},
signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,crisp:!1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0});return c}(q);l(g.prototype,{nameComponents:["longPeriod","shortPeriod",
"signalPeriod"],pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:m,getColumnMetrics:f.seriesTypes.column.prototype.getColumnMetrics,crispCol:f.seriesTypes.column.prototype.crispCol,drawPoints:f.seriesTypes.column.prototype.drawPoints});e.registerSeriesType("macd",g);"";return g});v(f,"Stock/Indicators/MFI/MFIIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function g(a){return a.reduce(function(a,b){return a+
b})}function k(a){return(a[1]+a[2]+a[3])/3}var m=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,d)};return function(b,d){function c(){this.constructor=b}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");a(b,d);b.prototype=null===d?Object.create(d):
(c.prototype=d.prototype,new c)}}(),q=f.seriesTypes.sma,l=e.extend,h=e.merge,d=e.error,a=e.isArray;e=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(c,b);c.prototype.getValues=function(b,c){var p=c.period,h=b.xData,e=b.yData,f=e?e.length:0,u=c.decimals,n=1,l=b.chart.get(c.volumeSeriesID),r=l&&l.yData,m=[],q=[],A=[],z=[],D=[];if(!l)d("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,b.chart);else if(!(h.length<=
p)&&a(e[0])&&4===e[0].length&&r){for(b=k(e[n]);n<p+1;)c=b,b=k(e[n]),c=b>=c,l=b*r[n],z.push(c?l:0),D.push(c?0:l),n++;for(p=n-1;p<f;p++)p>n-1&&(z.shift(),D.shift(),c=b,b=k(e[p]),c=b>c,l=b*r[p],z.push(c?l:0),D.push(c?0:l)),c=g(D),l=g(z),c=l/c,c=parseFloat((100-100/(1+c)).toFixed(u)),m.push([h[p],c]),q.push(h[p]),A.push(c);return{values:m,xData:q,yData:A}}};c.defaultOptions=h(q.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",decimals:4}});return c}(q);l(e.prototype,{nameBase:"Money Flow Index"});
f.registerSeriesType("mfi",e);"";return e});v(f,"Stock/Indicators/Momentum/MomentumIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==
a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.sma,m=e.extend,q=e.isArray,l=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.getValues=function(a,b){var c=b.period;b=b.index;var d=a.xData,h=(a=a.yData)?a.length:0,e=[],f=[],g=[],k;if(!(d.length<=c)&&q(a[0])){for(k=
c+1;k<h;k++){var t=[d[k-1],a[k-1][b]-a[k-c-1][b]];e.push(t);f.push(t[0]);g.push(t[1])}t=[d[k-1],a[k-1][b]-a[k-c-1][b]];e.push(t);f.push(t[0]);g.push(t[1]);return{values:e,xData:f,yData:g}}};d.defaultOptions=l(k.defaultOptions,{params:{index:3}});return d}(k);m(e.prototype,{nameBase:"Momentum"});f.registerSeriesType("momentum",e);"";return e});v(f,"Stock/Indicators/NATR/NATRIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=
function(f,h){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,a){d.__proto__=a}||function(d,a){for(var b in a)Object.prototype.hasOwnProperty.call(a,b)&&(d[b]=a[b])};return e(f,h)};return function(f,h){function d(){this.constructor=f}if("function"!==typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");e(f,h);f.prototype=null===h?Object.create(h):(d.prototype=h.prototype,new d)}}(),k=f.seriesTypes.atr,m=e.merge;e=function(e){function f(){var h=
null!==e&&e.apply(this,arguments)||this;h.data=void 0;h.points=void 0;h.options=void 0;return h}g(f,e);f.prototype.getValues=function(h,d){var a=k.prototype.getValues.apply(this,arguments),b=a.values.length,c=d.period-1,p=h.yData,e=0;if(a){for(;e<b;e++)a.yData[e]=a.values[e][1]/p[c][3]*100,a.values[e][1]=a.yData[e],c++;return a}};f.defaultOptions=m(k.defaultOptions,{tooltip:{valueSuffix:"%"}});return f}(k);f.registerSeriesType("natr",e);"";return e});v(f,"Stock/Indicators/OBV/OBVIndicator.js",[f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");d(a,b);a.prototype=null===b?Object.create(b):
(c.prototype=b.prototype,new c)}}(),k=f.seriesTypes.sma,m=e.isNumber,q=e.error,l=e.extend,h=e.merge;e=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}g(a,d);a.prototype.getValues=function(a,c){var b=a.chart.get(c.volumeSeriesID),d=a.xData,e=a.yData,h=[],f=[],g=[],k=!m(e[0]),n=1,l=0;if(b){b=b.yData;a=[d[0],l];var r=k?e[0][3]:e[0];h.push(a);f.push(d[0]);g.push(a[1]);for(n;n<e.length;n++)c=k?e[n][3]:e[n],l=c>r?l+b[n]:c===
r?l:l-b[n],a=[d[n],l],r=c,h.push(a),f.push(d[n]),g.push(a[1]);return{values:h,xData:f,yData:g}}q("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,a.chart)};a.defaultOptions=h(k.defaultOptions,{marker:{enabled:!1},params:{index:void 0,period:void 0,volumeSeriesID:"volume"},tooltip:{valueDecimals:0}});return a}(k);l(e.prototype,{nameComponents:void 0});f.registerSeriesType("obv",e);"";return e});v(f,"Stock/Indicators/PivotPoints/PivotPointsPoint.js",[f["Core/Series/SeriesRegistry.js"]],
function(f){function e(e,g){var k=e.series.pointArrayMap,l=k.length;for(f.seriesTypes.sma.prototype.pointClass.prototype[g].call(e);l--;)g="dataLabel"+k[l],e[g]&&e[g].element&&e[g].destroy(),e[g]=null}var g=this&&this.__extends||function(){var e=function(f,g){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,h){e.__proto__=h}||function(e,h){for(var d in h)Object.prototype.hasOwnProperty.call(h,d)&&(e[d]=h[d])};return e(f,g)};return function(f,g){function k(){this.constructor=f}if("function"!==
typeof g&&null!==g)throw new TypeError("Class extends value "+String(g)+" is not a constructor or null");e(f,g);f.prototype=null===g?Object.create(g):(k.prototype=g.prototype,new k)}}();return function(f){function k(){var e=null!==f&&f.apply(this,arguments)||this;e.P=void 0;e.pivotLine=void 0;e.series=void 0;return e}g(k,f);k.prototype.destroyElements=function(){e(this,"destroyElements")};k.prototype.destroy=function(){e(this,"destroyElements")};return k}(f.seriesTypes.sma.prototype.pointClass)});
v(f,"Stock/Indicators/PivotPoints/PivotPointsIndicator.js",[f["Stock/Indicators/PivotPoints/PivotPointsPoint.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==
typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),m=e.seriesTypes.sma,q=g.merge,l=g.extend,h=g.defined,d=g.isArray;g=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;b.endPoint=void 0;b.plotEndPoint=void 0;return b}k(b,a);b.prototype.toYData=function(a){return[a.P]};b.prototype.translate=function(){var a=
this;e.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(c){h(b[c])&&(b["plot"+c]=a.yAxis.toPixels(b[c],!0))})});a.plotEndPoint=a.xAxis.toPixels(a.endPoint,!0)};b.prototype.getGraphPath=function(a){for(var b=this,c=a.length,d=[[],[],[],[],[],[],[],[],[]],f=[],g=b.plotEndPoint,k=b.pointArrayMap.length,t,n,l;c--;){n=a[c];for(l=0;l<k;l++)t=b.pointArrayMap[l],h(n[t])&&d[l].push({plotX:n.plotX,plotY:n["plot"+t],isNull:!1},{plotX:g,plotY:n["plot"+
t],isNull:!1},{plotX:g,plotY:null,isNull:!0});g=n.plotX}d.forEach(function(a){f=f.concat(e.seriesTypes.sma.prototype.getGraphPath.call(b,a))});return f};b.prototype.drawDataLabels=function(){var a=this,b=a.pointArrayMap,d,h,f;if(a.options.dataLabels.enabled){var g=a.points.length;b.concat([!1]).forEach(function(c,p){for(f=g;f--;)h=a.points[f],c?(h.y=h[c],h.pivotLine=c,h.plotY=h["plot"+c],d=h["dataLabel"+c],p&&(h["dataLabel"+b[p-1]]=h.dataLabel),h.dataLabels||(h.dataLabels=[]),h.dataLabels[0]=h.dataLabel=
d=d&&d.element?d:null):h["dataLabel"+b[p-1]]=h.dataLabel;e.seriesTypes.sma.prototype.drawDataLabels.call(a)})}};b.prototype.getValues=function(a,b){var c=b.period,e=a.xData,h=(a=a.yData)?a.length:0;b=this[b.algorithm+"Placement"];var p=[],f=[],g=[],n;if(!(e.length<c)&&d(a[0])&&4===a[0].length){for(n=c+1;n<=h+c;n+=c){var k=e.slice(n-c-1,n);var l=a.slice(n-c-1,n);var m=k.length;var q=k[m-1];l=this.getPivotAndHLC(l);l=b(l);l=p.push([q].concat(l));f.push(q);g.push(p[l-1].slice(1))}this.endPoint=k[0]+
(q-k[0])/m*c;return{values:p,xData:f,yData:g}}};b.prototype.getPivotAndHLC=function(a){var b=-Infinity,c=Infinity,d=a[a.length-1][3];a.forEach(function(a){b=Math.max(b,a[1]);c=Math.min(c,a[2])});return[(b+c+d)/3,b,c,d]};b.prototype.standardPlacement=function(a){var b=a[1]-a[2];return[null,null,a[0]+b,2*a[0]-a[2],a[0],2*a[0]-a[1],a[0]-b,null,null]};b.prototype.camarillaPlacement=function(a){var b=a[1]-a[2];return[a[3]+1.5*b,a[3]+1.25*b,a[3]+1.1666*b,a[3]+1.0833*b,a[0],a[3]-1.0833*b,a[3]-1.1666*b,a[3]-
1.25*b,a[3]-1.5*b]};b.prototype.fibonacciPlacement=function(a){var b=a[1]-a[2];return[null,a[0]+b,a[0]+.618*b,a[0]+.382*b,a[0],a[0]-.382*b,a[0]-.618*b,a[0]-b,null]};b.defaultOptions=q(m.defaultOptions,{params:{index:void 0,period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}});return b}(m);l(g.prototype,{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",
pointClass:f});e.registerSeriesType("pivotpoints",g);"";return g});v(f,"Stock/Indicators/PPO/PPOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}if("function"!==typeof b&&
null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),k=f.seriesTypes.ema,m=e.correctFloat,q=e.extend,l=e.merge,h=e.error;e=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(a,d);a.prototype.getValues=function(a,c){var b=c.periods,d=c.index;c=[];var e=[],f=[],g;if(2!==b.length||b[1]<=b[0])h('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');
else{var l=k.prototype.getValues.call(this,a,{index:d,period:b[0]});a=k.prototype.getValues.call(this,a,{index:d,period:b[1]});if(l&&a){b=b[1]-b[0];for(g=0;g<a.yData.length;g++)d=m((l.yData[g+b]-a.yData[g])/a.yData[g]*100),c.push([a.xData[g],d]),e.push(a.xData[g]),f.push(d);return{values:c,xData:e,yData:f}}}};a.defaultOptions=l(k.defaultOptions,{params:{period:void 0,periods:[12,26]}});return a}(k);q(e.prototype,{nameBase:"PPO",nameComponents:["periods"]});f.registerSeriesType("ppo",e);"";return e});
v(f,"Stock/Indicators/ArrayUtilities.js",[],function(){return{getArrayExtremes:function(f,e,g){return f.reduce(function(f,m){return[Math.min(f[0],m[e]),Math.max(f[1],m[g])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});v(f,"Stock/Indicators/PC/PCIndicator.js",[f["Stock/Indicators/ArrayUtilities.js"],f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Color/Palettes.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g,k,m){var q=this&&this.__extends||function(){var a=function(b,
c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),l=k.seriesTypes.sma,h=m.merge;m=m.extend;var d=function(a){function b(){var b=
null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}q(b,a);b.prototype.getValues=function(a,b){b=b.period;var c=a.xData,d=(a=a.yData)?a.length:0,e=[],h=[],p=[],g;if(!(d<b)){for(g=b;g<=d;g++){var n=c[g-1];var k=a.slice(g-b,g);var l=f.getArrayExtremes(k,2,1);k=l[1];var m=l[0];l=(k+m)/2;e.push([n,k,l,m]);h.push(n);p.push([k,l,m])}return{values:e,xData:h,yData:p}}};b.defaultOptions=h(l.defaultOptions,{params:{index:void 0,period:20},lineWidth:1,topLine:{styles:{lineColor:g.colors[2],
lineWidth:1}},bottomLine:{styles:{lineColor:g.colors[8],lineWidth:1}},dataGrouping:{approximation:"averages"}});return b}(l);m(d.prototype,{areaLinesNames:["top","bottom"],nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});e.compose(d);k.registerSeriesType("pc",d);"";return d});v(f,"Stock/Indicators/PriceEnvelopes/PriceEnvelopesIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],
function(f,e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,
new b)}}(),k=f.seriesTypes.sma,m=e.extend,q=e.isArray,l=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.init=function(){f.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=l({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};d.prototype.toYData=function(a){return[a.top,a.middle,a.bottom]};d.prototype.translate=function(){var a=
this,b=["plotTop","plotMiddle","plotBottom"];f.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(c){[c.top,c.middle,c.bottom].forEach(function(d,e){null!==d&&(c[b[e]]=a.yAxis.toPixels(d,!0))})})};d.prototype.drawGraph=function(){for(var a=this,b=a.points,c=b.length,d=a.options,e=a.graph,h={options:{gapSize:d.gapSize}},g=[[],[]],k;c--;)k=b[c],g[0].push({plotX:k.plotX,plotY:k.plotTop,isNull:k.isNull}),g[1].push({plotX:k.plotX,plotY:k.plotBottom,isNull:k.isNull});["topLine","bottomLine"].forEach(function(b,
c){a.points=g[c];a.options=l(d[b].styles,h);a.graph=a["graph"+b];f.seriesTypes.sma.prototype.drawGraph.call(a);a["graph"+b]=a.graph});a.points=b;a.options=d;a.graph=e;f.seriesTypes.sma.prototype.drawGraph.call(a)};d.prototype.getValues=function(a,b){var c=b.period,d=b.topBand,e=b.bottomBand,h=a.xData,g=(a=a.yData)?a.length:0,k=[],l=[],t=[],n;if(!(h.length<c)&&q(a[0])&&4===a[0].length){for(n=c;n<=g;n++){var m=h.slice(n-c,n);var r=a.slice(n-c,n);r=f.seriesTypes.sma.prototype.getValues.call(this,{xData:m,
yData:r},b);m=r.xData[0];r=r.yData[0];var B=r*(1+d);var I=r*(1-e);k.push([m,B,r,I]);l.push(m);t.push([B,r,I])}return{values:k,xData:l,yData:t}}};d.defaultOptions=l(k.defaultOptions,{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},
dataGrouping:{approximation:"averages"}});return d}(k);m(e.prototype,{nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle"});f.registerSeriesType("priceenvelopes",e);"";return e});v(f,"Stock/Indicators/PSAR/PSARIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(h,d){e=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return e(h,d)};return function(h,d){function a(){this.constructor=h}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");e(h,d);h.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=f.seriesTypes.sma,m=e.merge;e=e.extend;var q=function(e){function h(){var d=null!==
e&&e.apply(this,arguments)||this;d.data=void 0;d.points=void 0;d.options=void 0;return d}g(h,e);h.prototype.getValues=function(d,a){var b=d.xData;d=d.yData;var c=d[0][1],e=a.maxAccelerationFactor,h=a.increment,f=a.initialAccelerationFactor,g=d[0][2],k=a.decimals,l=a.index,t=[],n=[],m=[],r=1,q;if(!(l>=d.length)){for(q=0;q<l;q++)c=Math.max(d[q][1],c),g=Math.min(d[q][2],parseFloat(g.toFixed(k)));var I=d[q][1]>g?1:-1;a=a.initialAccelerationFactor;var A=a*(c-g);t.push([b[l],g]);n.push(b[l]);m.push(parseFloat(g.toFixed(k)));
for(q=l+1;q<d.length;q++){l=d[q-1][2];var z=d[q-2][2];var D=d[q-1][1];var v=d[q-2][1];var E=d[q][1];var F=d[q][2];null!==z&&null!==v&&null!==l&&null!==D&&null!==E&&null!==F&&(g=I===r?1===I?g+A<Math.min(z,l)?g+A:Math.min(z,l):g+A>Math.max(v,D)?g+A:Math.max(v,D):c,l=1===I?E>c?E:c:F<c?F:c,E=1===r&&F>g||-1===r&&E>g?1:-1,r=E,A=l,F=h,z=e,D=f,a=r===I?1===r&&A>c?a===z?z:parseFloat((a+F).toFixed(2)):-1===r&&A<c?a===z?z:parseFloat((a+F).toFixed(2)):a:D,c=l-g,A=a*c,t.push([b[q],parseFloat(g.toFixed(k))]),n.push(b[q]),
m.push(parseFloat(g.toFixed(k))),r=I,I=E,c=l)}return{values:t,xData:n,yData:m}}};h.defaultOptions=m(k.defaultOptions,{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{period:void 0,initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}});return h}(k);e(q.prototype,{nameComponents:void 0});f.registerSeriesType("psar",q);"";return q});v(f,"Stock/Indicators/ROC/ROCIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,
e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),
k=f.seriesTypes.sma,m=e.isArray,q=e.merge;e=e.extend;var l=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.getValues=function(a,b){var c=b.period,d=a.xData,e=(a=a.yData)?a.length:0,f=[],h=[],g=[],k=-1;if(!(d.length<=c)){m(a[0])&&(k=b.index);for(b=c;b<e;b++){var l=0>k?(l=a[b-c])?(a[b]-l)/l*100:null:(l=a[b-c][k])?(a[b][k]-l)/l*100:null;l=[d[b],l];f.push(l);h.push(l[0]);g.push(l[1])}return{values:f,xData:h,
yData:g}}};d.defaultOptions=q(k.defaultOptions,{params:{index:3,period:9}});return d}(k);e(l.prototype,{nameBase:"Rate of Change"});f.registerSeriesType("roc",l);"";return l});v(f,"Stock/Indicators/RSI/RSIIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,
c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=f.seriesTypes.sma,m=e.isNumber,q=e.merge;e=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.points=void 0;d.options=void 0;return d}g(f,e);f.prototype.getValues=function(d,a){var b=
a.period,c=d.xData,e=d.yData;d=e?e.length:0;var f=a.decimals,h=1,g=[],k=[],l=[],t=a.index,n=a=0,q;if(!(c.length<b)){if(m(e[0]))var r=e;else t=Math.min(t,e[0].length-1),r=e.map(function(a){return a[t]});for(;h<b;){var B=parseFloat((r[h]-r[h-1]).toFixed(f));0<B?a+=B:n+=Math.abs(B);h++}e=parseFloat((a/(b-1)).toFixed(f));for(q=parseFloat((n/(b-1)).toFixed(f));h<d;h++)B=parseFloat((r[h]-r[h-1]).toFixed(f)),0<B?(a=B,n=0):(a=0,n=Math.abs(B)),e=parseFloat(((e*(b-1)+a)/b).toFixed(f)),q=parseFloat(((q*(b-1)+
n)/b).toFixed(f)),a=0===q?100:0===e?0:parseFloat((100-100/(1+e/q)).toFixed(f)),g.push([c[h],a]),k.push(c[h]),l.push(a);return{values:g,xData:k,yData:l}}};f.defaultOptions=q(k.defaultOptions,{params:{decimals:4,index:3}});return f}(k);f.registerSeriesType("rsi",e);"";return e});v(f,"Stock/Indicators/Stochastic/StochasticIndicator.js",[f["Stock/Indicators/ArrayUtilities.js"],f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g,k){var m=
this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),q=g.seriesTypes.sma,
l=k.extend,h=k.isArray,d=k.merge;k=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}m(b,a);b.prototype.init=function(){g.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=d({smoothedLine:{styles:{lineColor:this.color}}},this.options)};b.prototype.getValues=function(a,b){var c=b.periods[0];b=b.periods[1];var d=a.xData,e=(a=a.yData)?a.length:0,p=[],k=[],l=[],n=null,m;if(!(e<c)&&h(a[0])&&4===a[0].length){for(m=
c-1;m<e;m++){var r=a.slice(m-c+1,m+1);var q=f.getArrayExtremes(r,2,1);var I=q[0];r=a[m][3]-I;I=q[1]-I;r=r/I*100;k.push(d[m]);l.push([r,null]);m>=c-1+(b-1)&&(n=g.seriesTypes.sma.prototype.getValues.call(this,{xData:k.slice(-b),yData:l.slice(-b)},{period:b}),n=n.yData[0]);p.push([d[m],r,n]);l[l.length-1][1]=n}return{values:p,xData:k,yData:l}}};b.defaultOptions=d(q.defaultOptions,{params:{index:void 0,period:void 0,periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},
smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}});return b}(q);l(k.prototype,{areaLinesNames:[],nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"]});e.compose(k);g.registerSeriesType("stochastic",k);"";return k});v(f,"Stock/Indicators/SlowStochastic/SlowStochasticIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,
e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),
k=f.seriesTypes,m=k.sma.prototype,q=k.stochastic;k=e.extend;var l=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.getValues=function(a,b){var c=b.periods,d=e.prototype.getValues.call(this,a,b);a={values:[],xData:[],yData:[]};b=0;if(d){a.xData=d.xData.slice(c[1]-1);d=d.yData.slice(c[1]-1);var f=m.getValues.call(this,{xData:a.xData,yData:d},{index:1,period:c[2]});if(f){for(var h=a.xData.length;b<
h;b++)a.yData[b]=[d[b][1],f.yData[b-c[2]+1]||null],a.values[b]=[a.xData[b],d[b][1],f.yData[b-c[2]+1]||null];return a}}};d.defaultOptions=l(q.defaultOptions,{params:{periods:[14,3,3]}});return d}(q);k(e.prototype,{nameBase:"Slow Stochastic"});f.registerSeriesType("slowstochastic",e);"";return e});v(f,"Stock/Indicators/Supertrend/SupertrendIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"],f["Core/Chart/StockChart.js"]],function(f,e,g){function k(a,b,c){return{index:b,close:a.yData[b][c],
x:a.xData[b]}}var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,
new d)}}(),q=f.seriesTypes,l=q.atr,h=q.sma,d=e.addEvent,a=e.correctFloat,b=e.isArray;q=e.extend;var c=e.merge,p=e.objectEach;e=function(e){function f(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.linkedParent=void 0;a.options=void 0;a.points=void 0;return a}m(f,e);f.prototype.init=function(){var a;h.prototype.init.apply(this,arguments);var b=this,c=d(g,"afterLinkSeries",function(){if(b.options){var d=b.options;a=b.linkedParent.options;d.cropThreshold=a.cropThreshold-(d.params.period-
1)}c()},{order:1})};f.prototype.drawGraph=function(){var a=this,b=a.options,d=a.linkedParent,e=d?d.points:[],f=a.points,g=a.graph,l=f.length,m=e.length-l;m=0<m?m:0;for(var q={options:{gapSize:b.gapSize}},u={top:[],bottom:[],intersect:[]},z={top:{styles:{lineWidth:b.lineWidth,lineColor:b.fallingTrendColor||b.color,dashStyle:b.dashStyle}},bottom:{styles:{lineWidth:b.lineWidth,lineColor:b.risingTrendColor||b.color,dashStyle:b.dashStyle}},intersect:b.changeTrendLine},D,C,E,F,v,J,K,L;l--;)D=f[l],C=f[l-
1],E=e[l-1+m],F=e[l-2+m],v=e[l+m],J=e[l+m+1],K=D.options.color,L={x:D.x,plotX:D.plotX,plotY:D.plotY,isNull:!1},!F&&E&&d.yData[E.index-1]&&(F=k(d,E.index-1,3)),!J&&v&&d.yData[v.index+1]&&(J=k(d,v.index+1,3)),!E&&F&&d.yData[F.index+1]?E=k(d,F.index+1,3):!E&&v&&d.yData[v.index-1]&&(E=k(d,v.index-1,3)),D&&E&&v&&F&&D.x!==E.x&&(D.x===v.x?(F=E,E=v):D.x===F.x?(E=F,F={close:d.yData[E.index-1][3],x:d.xData[E.index-1]}):J&&D.x===J.x&&(E=J,F=v)),C&&F&&E?(v={x:C.x,plotX:C.plotX,plotY:C.plotY,isNull:!1},D.y>=E.close&&
C.y>=F.close?(D.color=K||b.fallingTrendColor||b.color,u.top.push(L)):D.y<E.close&&C.y<F.close?(D.color=K||b.risingTrendColor||b.color,u.bottom.push(L)):(u.intersect.push(L),u.intersect.push(v),u.intersect.push(c(v,{isNull:!0})),D.y>=E.close&&C.y<F.close?(D.color=K||b.fallingTrendColor||b.color,C.color=K||b.risingTrendColor||b.color,u.top.push(L),u.top.push(c(v,{isNull:!0}))):D.y<E.close&&C.y>=F.close&&(D.color=K||b.risingTrendColor||b.color,C.color=K||b.fallingTrendColor||b.color,u.bottom.push(L),
u.bottom.push(c(v,{isNull:!0}))))):E&&(D.y>=E.close?(D.color=K||b.fallingTrendColor||b.color,u.top.push(L)):(D.color=K||b.risingTrendColor||b.color,u.bottom.push(L)));p(u,function(b,d){a.points=b;a.options=c(z[d].styles,q);a.graph=a["graph"+d+"Line"];h.prototype.drawGraph.call(a);a["graph"+d+"Line"]=a.graph});a.points=f;a.options=b;a.graph=g};f.prototype.getValues=function(c,d){var e=d.period;d=d.multiplier;var f=c.xData,h=c.yData,g=[],p=[],k=[],m=0===e?0:e-1,q=[],u=[],w;if(!(f.length<=e||!b(h[0])||
4!==h[0].length||0>e)){c=l.prototype.getValues.call(this,c,{period:e}).yData;for(w=0;w<c.length;w++){var y=h[m+w];var v=h[m+w-1]||[];var C=q[w-1];var z=u[w-1];var J=k[w-1];0===w&&(C=z=J=0);e=a((y[1]+y[2])/2+d*c[w]);var K=a((y[1]+y[2])/2-d*c[w]);q[w]=e<C||v[3]>C?e:C;u[w]=K>z||v[3]<z?K:z;if(J===C&&y[3]<q[w]||J===z&&y[3]<u[w])var L=q[w];else if(J===C&&y[3]>q[w]||J===z&&y[3]>u[w])L=u[w];g.push([f[m+w],L]);p.push(f[m+w]);k.push(L)}return{values:g,xData:p,yData:k}}};f.defaultOptions=c(h.defaultOptions,
{params:{index:void 0,multiplier:3,period:10},risingTrendColor:"#06b535",fallingTrendColor:"#f21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}});return f}(h);q(e.prototype,{nameBase:"Supertrend",nameComponents:["multiplier","period"]});f.registerSeriesType("supertrend",e);"";return e});v(f,"Stock/Indicators/VBP/VBPPoint.js",[f["Core/Series/SeriesRegistry.js"]],function(f){var e=this&&this.__extends||function(){var e=function(f,g){e=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(e,f){e.__proto__=f}||function(e,f){for(var h in f)Object.prototype.hasOwnProperty.call(f,h)&&(e[h]=f[h])};return e(f,g)};return function(f,g){function k(){this.constructor=f}if("function"!==typeof g&&null!==g)throw new TypeError("Class extends value "+String(g)+" is not a constructor or null");e(f,g);f.prototype=null===g?Object.create(g):(k.prototype=g.prototype,new k)}}();return function(f){function g(){return null!==f&&f.apply(this,arguments)||this}e(g,f);g.prototype.destroy=function(){this.negativeGraphic&&
(this.negativeGraphic=this.negativeGraphic.destroy());return f.prototype.destroy.apply(this,arguments)};return g}(f.seriesTypes.sma.prototype.pointClass)});v(f,"Stock/Indicators/VBP/VBPIndicator.js",[f["Stock/Indicators/VBP/VBPPoint.js"],f["Core/Animation/AnimationUtilities.js"],f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"],f["Core/Chart/StockChart.js"]],function(f,e,g,k,m,q){var l=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),h=e.animObject;e=g.noop;var d=k.seriesTypes,a=d.column.prototype,b=d.sma,c=m.addEvent,p=m.arrayMax,u=m.arrayMin,
C=m.correctFloat,w=m.defined,y=m.error,v=m.extend,t=m.isArray,n=m.merge,x=Math.abs;m=function(d){function e(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.negWidths=void 0;a.options=void 0;a.points=void 0;a.posWidths=void 0;a.priceZones=void 0;a.rangeStep=void 0;a.volumeDataArray=void 0;a.zoneStarts=void 0;a.zoneLinesSVG=void 0;return a}l(e,d);e.prototype.init=function(a){var b=this,d,e,f;g.seriesTypes.sma.prototype.init.apply(b,arguments);var h=c(q,"afterLinkSeries",function(){b.options&&
(d=b.options.params,e=b.linkedParent,f=a.get(d.volumeSeriesID),b.addCustomEvents(e,f));h()},{order:1});return b};e.prototype.addCustomEvents=function(a,b){function d(){e.chart.redraw();e.setData([]);e.zoneStarts=[];e.zoneLinesSVG&&(e.zoneLinesSVG=e.zoneLinesSVG.destroy())}var e=this;e.dataEventsToUnbind.push(c(a,"remove",function(){d()}));b&&e.dataEventsToUnbind.push(c(b,"remove",function(){d()}));return e};e.prototype.animate=function(a){var b=this,c=b.chart.inverted,d=b.group,e={};!a&&d&&(a=c?b.yAxis.top:
b.xAxis.left,c?(d["forceAnimate:translateY"]=!0,e.translateY=a):(d["forceAnimate:translateX"]=!0,e.translateX=a),d.animate(e,v(h(b.options.animation),{step:function(a,c){b.group.attr({scaleX:Math.max(.001,c.pos)})}})))};e.prototype.drawPoints=function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),a.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));a.drawPoints.apply(this,arguments)};e.prototype.posNegVolume=function(a,b){var c=b?["positive","negative"]:["negative","positive"],
d=this.options.volumeDivision,e=this.points.length,f=[],h=[],g=0,p;a?(this.posWidths=f,this.negWidths=h):(f=this.posWidths,h=this.negWidths);for(;g<e;g++){var k=this.points[g];k[c[0]+"Graphic"]=k.graphic;k.graphic=k[c[1]+"Graphic"];if(a){var l=k.shapeArgs.width;var n=this.priceZones[g];(p=n.wholeVolumeData)?(f.push(l/p*n.positiveVolumeData),h.push(l/p*n.negativeVolumeData)):(f.push(0),h.push(0))}k.color=b?d.styles.positiveColor:d.styles.negativeColor;k.shapeArgs.width=b?this.posWidths[g]:this.negWidths[g];
k.shapeArgs.x=b?k.shapeArgs.x:this.posWidths[g]}};e.prototype.translate=function(){var b=this,c=b.options,d=b.chart,e=b.yAxis,f=e.min,h=b.options.zoneLines,g=b.priceZones,k=0,l,n,m;a.translate.apply(b);var t=b.points;if(t.length){var q=.5>c.pointPadding?c.pointPadding:.1;c=b.volumeDataArray;var r=p(c);var u=d.plotWidth/2;var w=d.plotTop;var y=x(e.toPixels(f)-e.toPixels(f+b.rangeStep));var v=x(e.toPixels(f)-e.toPixels(f+b.rangeStep));q&&(f=x(y*(1-2*q)),k=x((y-f)/2),y=x(f));t.forEach(function(a,c){n=
a.barX=a.plotX=0;m=a.plotY=e.toPixels(g[c].start)-w-(e.reversed?y-v:y)-k;l=C(u*g[c].wholeVolumeData/r);a.pointWidth=l;a.shapeArgs=b.crispCol.apply(b,[n,m,l,y]);a.volumeNeg=g[c].negativeVolumeData;a.volumePos=g[c].positiveVolumeData;a.volumeAll=g[c].wholeVolumeData});h.enabled&&b.drawZones(d,e,b.zoneStarts,h.styles)}};e.prototype.getValues=function(a,b){var c=a.processedXData,d=a.processedYData,e=this.chart,f=b.ranges,h=[],g=[],p=[],k;if(a.chart)if(k=e.get(b.volumeSeriesID))if((b=t(d[0]))&&4!==d[0].length)y("Type of "+
a.name+" series is different than line, OHLC or candlestick.",!0,e);else return(this.priceZones=this.specifyZones(b,c,d,f,k)).forEach(function(a,b){h.push([a.x,a.end]);g.push(h[b][0]);p.push(h[b][1])}),{values:h,xData:g,yData:p};else y("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,e);else y("Base series not found! In case it has been removed, add a new one.",!0,e)};e.prototype.specifyZones=function(a,b,c,d,e){if(a){var f=c.length;for(var h=c[0][3],g=h,k=1,l;k<f;k++)l=c[k][3],
l<h&&(h=l),l>g&&(g=l);f={min:h,max:g}}else f=!1;f=(h=f)?h.min:u(c);l=h?h.max:p(c);h=this.zoneStarts=[];g=[];var n=0;k=1;var m=this.linkedParent;!this.options.compareToMain&&m.dataModify&&(f=m.dataModify.modifyValue(f),l=m.dataModify.modifyValue(l));if(!w(f)||!w(l))return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG&&(this.zoneLinesSVG=this.zoneLinesSVG.destroy())),[];m=this.rangeStep=C(l-f)/d;for(h.push(f);n<d-1;n++)h.push(C(h[n]+m));h.push(l);for(d=h.length;k<d;k++)g.push({index:k-
1,x:b[0],start:h[k-1],end:h[k]});return this.volumePerZone(a,g,e,b,c)};e.prototype.volumePerZone=function(a,b,c,d,e){var f=this,h=c.processedXData,g=c.processedYData,p=b.length-1,k=e.length;c=g.length;var l,n,m,t,q;x(k-c)&&(d[0]!==h[0]&&g.unshift(0),d[k-1]!==h[c-1]&&g.push(0));f.volumeDataArray=[];b.forEach(function(b){b.wholeVolumeData=0;b.positiveVolumeData=0;for(q=b.negativeVolumeData=0;q<k;q++){m=n=!1;t=a?e[q][3]:e[q];l=q?a?e[q-1][3]:e[q-1]:t;var c=f.linkedParent;!f.options.compareToMain&&c.dataModify&&
(t=c.dataModify.modifyValue(t),l=c.dataModify.modifyValue(l));t<=b.start&&0===b.index&&(n=!0);t>=b.end&&b.index===p&&(m=!0);(t>b.start||n)&&(t<b.end||m)&&(b.wholeVolumeData+=g[q],l>t?b.negativeVolumeData+=g[q]:b.positiveVolumeData+=g[q])}f.volumeDataArray.push(b.wholeVolumeData)});return b};e.prototype.drawZones=function(a,b,c,d){var e=a.renderer,f=this.zoneLinesSVG,h=[],g=a.plotWidth,p=a.plotTop,k;c.forEach(function(c){k=b.toPixels(c)-p;h=h.concat(a.renderer.crispLine([["M",0,k],["L",g,k]],d.lineWidth))});
f?f.animate({d:h}):f=this.zoneLinesSVG=e.path(h).attr({"stroke-width":d.lineWidth,stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)};e.defaultOptions=n(b.defaultOptions,{params:{index:void 0,period:void 0,ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,
pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}});return e}(b);v(m.prototype,{nameBase:"Volume by Price",nameComponents:["ranges"],calculateOn:{chart:"render",xAxis:"afterSetExtremes"},pointClass:f,markerAttribs:e,drawGraph:e,getColumnMetrics:a.getColumnMetrics,crispCol:a.crispCol});k.registerSeriesType("vbp",m);"";return m});v(f,"Stock/Indicators/VWAP/VWAPIndicator.js",
[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");e(d,a);
d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.sma,m=e.error,q=e.isArray,l=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}g(d,e);d.prototype.getValues=function(a,b){var c=a.chart,d=a.xData;a=a.yData;var e=b.period,f=!0,h;if(h=c.get(b.volumeSeriesID))return q(a[0])||(f=!1),this.calculateVWAPValues(f,d,a,h,e);m("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",
!0,c)};d.prototype.calculateVWAPValues=function(a,b,c,d,e){var f=d.yData,h=d.xData.length,g=b.length;d=[];var p=[],k=[],l=[],m=[],q;h=g<=h?g:h;for(q=g=0;g<h;g++){var u=a?(c[g][1]+c[g][2]+c[g][3])/3:c[g];u*=f[g];u=q?d[g-1]+u:u;var v=q?p[g-1]+f[g]:f[g];d.push(u);p.push(v);m.push([b[g],u/v]);k.push(m[g][0]);l.push(m[g][1]);q++;q===e&&(q=0)}return{values:m,xData:k,yData:l}};d.defaultOptions=l(k.defaultOptions,{params:{index:void 0,period:30,volumeSeriesID:"volume"}});return d}(k);f.registerSeriesType("vwap",
e);"";return e});v(f,"Stock/Indicators/WilliamsR/WilliamsRIndicator.js",[f["Stock/Indicators/ArrayUtilities.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}if("function"!==
typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),m=e.seriesTypes.sma,q=g.extend,l=g.isArray,h=g.merge;g=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(a,d);a.prototype.getValues=function(a,c){c=c.period;var b=a.xData,d=(a=a.yData)?a.length:0,e=[],h=[],g=[],k;if(!(b.length<c)&&l(a[0])&&
4===a[0].length){for(k=c-1;k<d;k++){var m=a.slice(k-c+1,k+1);var n=f.getArrayExtremes(m,2,1);m=n[0];n=n[1];var q=a[k][3];m=(n-q)/(n-m)*-100;b[k]&&(e.push([b[k],m]),h.push(b[k]),g.push(m))}return{values:e,xData:h,yData:g}}};a.defaultOptions=h(m.defaultOptions,{params:{index:void 0,period:14}});return a}(m);q(g.prototype,{nameBase:"Williams %R"});e.registerSeriesType("williamsr",g);"";return g});v(f,"Stock/Indicators/WMA/WMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,
e){function g(d,a){a*=(a+1)/2;return d.reduce(function(a,c,d){return[null,a[1]+c[1]*(d+1)]})[1]/a}function k(d,a,b,c){b=g(d,d.length);a=a[c-1];d.shift();return[a,b]}var m=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+
String(b)+" is not a constructor or null");d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),q=f.seriesTypes.sma,l=e.isArray,h=e.merge;e=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,d);a.prototype.getValues=function(a,c){var b=c.period,d=a.xData,e=(a=a.yData)?a.length:0,f=1,h=d[0],g=a[0],m=[],n=[],q=[],r=-1;if(!(d.length<b)){l(a[0])&&(r=c.index,g=a[0][r]);for(c=[[h,g]];f!==b;)c.push([d[f],
0>r?a[f]:a[f][r]]),f++;for(b=f;b<e;b++)f=k(c,d,a,b),m.push(f),n.push(f[0]),q.push(f[1]),c.push([d[b],0>r?a[b]:a[b][r]]);f=k(c,d,a,b);m.push(f);n.push(f[0]);q.push(f[1]);return{values:m,xData:n,yData:q}}};a.defaultOptions=h(q.defaultOptions,{params:{index:3,period:9}});return a}(q);f.registerSeriesType("wma",e);"";return e});v(f,"Stock/Indicators/Zigzag/ZigzagIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,
d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=f.seriesTypes.sma,m=e.merge;e=e.extend;var q=function(e){function f(){var d=
null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.points=void 0;d.options=void 0;return d}g(f,e);f.prototype.getValues=function(d,a){var b=a.lowIndex,c=a.highIndex,e=a.deviation/100;a=1+e;var f=1-e;e=d.xData;var h=d.yData;d=h?h.length:0;var g=[],k=[],l=[],m,n,q=!1,r=!1;if(!(!e||1>=e.length||d&&("undefined"===typeof h[0][b]||"undefined"===typeof h[0][c]))){var v=h[0][b];var z=h[0][c];for(m=1;m<d;m++){if(h[m][b]<=z*f){g.push([e[0],z]);var A=[e[m],h[m][b]];q=n=!0}else h[m][c]>=v*a&&(g.push([e[0],
v]),A=[e[m],h[m][c]],n=!1,q=!0);if(q){k.push(g[0][0]);l.push(g[0][1]);var M=m++;m=d}}for(m=M;m<d;m++)n?(h[m][b]<=A[1]&&(A=[e[m],h[m][b]]),h[m][c]>=A[1]*a&&(r=c)):(h[m][c]>=A[1]&&(A=[e[m],h[m][c]]),h[m][b]<=A[1]*f&&(r=b)),!1!==r&&(g.push(A),k.push(A[0]),l.push(A[1]),A=[e[m],h[m][r]],n=!n,r=!1);b=g.length;0!==b&&g[b-1][0]<e[d-1]&&(g.push(A),k.push(A[0]),l.push(A[1]));return{values:g,xData:k,yData:l}}};f.defaultOptions=m(k.defaultOptions,{params:{index:void 0,period:void 0,lowIndex:2,highIndex:1,deviation:1}});
return f}(k);e(q.prototype,{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag"});f.registerSeriesType("zigzag",q);"";return q});v(f,"Stock/Indicators/LinearRegression/LinearRegressionIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,
b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.sma,m=e.isArray,q=e.extend,l=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.getRegressionLineParameters=
function(a,b){var c=this.options.params.index,d=function(a,b){return m(a)?a[b]:a},e=a.reduce(function(a,b){return b+a},0),f=b.reduce(function(a,b){return d(b,c)+a},0);e/=a.length;f/=b.length;var h=0,g=0,k;for(k=0;k<a.length;k++){var l=a[k]-e;var n=d(b[k],c)-f;h+=l*n;g+=Math.pow(l,2)}a=g?h/g:0;return{slope:a,intercept:f-a*e}};d.prototype.getEndPointY=function(a,b){return a.slope*b+a.intercept};d.prototype.transformXData=function(a,b){var c=a[0];return a.map(function(a){return(a-c)/b})};d.prototype.findClosestDistance=
function(a){var b,c;for(c=1;c<a.length-1;c++){var d=a[c]-a[c-1];0<d&&("undefined"===typeof b||d<b)&&(b=d)}return b};d.prototype.getValues=function(a,b){var c=a.xData;a=a.yData;b=b.period;var d,e={xData:[],yData:[],values:[]},f=this.options.params.xAxisUnit||this.findClosestDistance(c);for(d=b-1;d<=c.length-1;d++){var h=d-b+1;var g=d+1;var k=c[d];var l=c.slice(h,g);h=a.slice(h,g);g=this.transformXData(l,f);l=this.getRegressionLineParameters(g,h);h=this.getEndPointY(l,g[g.length-1]);e.values.push({regressionLineParameters:l,
x:k,y:h});e.xData.push(k);e.yData.push(h)}return e};d.defaultOptions=l(k.defaultOptions,{params:{xAxisUnit:null},tooltip:{valueDecimals:4}});return d}(k);q(e.prototype,{nameBase:"Linear Regression Indicator"});f.registerSeriesType("linearRegression",e);"";return e});v(f,"Stock/Indicators/LinearRegressionSlopes/LinearRegressionSlopesIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=f.seriesTypes.linearRegression,m=e.extend,q=e.merge;e=function(e){function f(){var d=
null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(f,e);f.prototype.getEndPointY=function(d){return d.slope};f.defaultOptions=q(k.defaultOptions);return f}(k);m(e.prototype,{nameBase:"Linear Regression Slope Indicator"});f.registerSeriesType("linearRegressionSlope",e);"";return e});v(f,"Stock/Indicators/LinearRegressionIntercept/LinearRegressionInterceptIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&
this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),k=f.seriesTypes.linearRegression,
m=e.extend,q=e.merge;e=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(f,e);f.prototype.getEndPointY=function(d){return d.intercept};f.defaultOptions=q(k.defaultOptions);return f}(k);m(e.prototype,{nameBase:"Linear Regression Intercept Indicator"});f.registerSeriesType("linearRegressionIntercept",e);"";return e});v(f,"Stock/Indicators/LinearRegressionAngle/LinearRegressionAngleIndicator.js",[f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}if("function"!==typeof d&&null!==d)throw new TypeError("Class extends value "+String(d)+" is not a constructor or null");e(f,d);f.prototype=null===d?Object.create(d):
(a.prototype=d.prototype,new a)}}(),k=f.seriesTypes.linearRegression,m=e.extend,q=e.merge;e=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(f,e);f.prototype.slopeToAngle=function(d){return 180/Math.PI*Math.atan(d)};f.prototype.getEndPointY=function(d){return this.slopeToAngle(d.slope)};f.defaultOptions=q(k.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}});
return f}(k);m(e.prototype,{nameBase:"Linear Regression Angle Indicator"});f.registerSeriesType("linearRegressionAngle",e);"";return e});v(f,"Stock/Indicators/ABands/ABandsIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var k=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,
c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}if("function"!==typeof b&&null!==b)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),m=e.seriesTypes.sma,q=g.correctFloat,l=g.extend,h=g.merge;g=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(a,d);a.prototype.getValues=
function(a,c){var b=c.period,e=c.factor;c=c.index;var f=a.xData,g=(a=a.yData)?a.length:0,h=[],k=[],l=[],n=[],m=[],r;if(!(g<b)){for(r=0;r<=g;r++){if(r<g){var v=a[r][2];var z=a[r][1];var A=e;v=q(z-v)/(q(z+v)/2)*1E3*A;h.push(a[r][1]*q(1+2*v));k.push(a[r][2]*q(1-2*v))}if(r>=b){v=f.slice(r-b,r);var M=a.slice(r-b,r);A=d.prototype.getValues.call(this,{xData:v,yData:h.slice(r-b,r)},{period:b});z=d.prototype.getValues.call(this,{xData:v,yData:k.slice(r-b,r)},{period:b});M=d.prototype.getValues.call(this,{xData:v,
yData:M},{period:b,index:c});v=M.xData[0];A=A.yData[0];z=z.yData[0];M=M.yData[0];l.push([v,A,M,z]);n.push(v);m.push([A,M,z])}}return{values:l,xData:n,yData:m}}};a.defaultOptions=h(m.defaultOptions,{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return a}(m);l(g.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameBase:"Acceleration Bands",nameComponents:["period",
"factor"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});f.compose(g);e.registerSeriesType("abands",g);"";return g});v(f,"Stock/Indicators/TrendLine/TrendLineIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)Object.prototype.hasOwnProperty.call(c,b)&&(a[b]=c[b])};return e(d,
a)};return function(d,a){function b(){this.constructor=d}if("function"!==typeof a&&null!==a)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.sma,m=e.extend,q=e.merge,l=e.isArray;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.getValues=function(a,b){var c=a.xData,d=a.yData;
a=[];var e=[],f=[],g=0,h=0,k=0,m=0,n=c.length,q=b.index;for(b=0;b<n;b++){var r=c[b];var v=l(d[b])?d[b][q]:d[b];g+=r;h+=v;k+=r*v;m+=r*r}d=(n*k-g*h)/(n*m-g*g);isNaN(d)&&(d=0);g=(h-d*g)/n;for(b=0;b<n;b++)r=c[b],v=d*r+g,a[b]=[r,v],e[b]=r,f[b]=v;return{xData:e,yData:f,values:a}};d.defaultOptions=q(k.defaultOptions,{params:{period:void 0,index:3}});return d}(k);m(e.prototype,{nameBase:"Trendline",nameComponents:!1});f.registerSeriesType("trendline",e);"";return e});v(f,"Stock/Indicators/DisparityIndex/DisparityIndexIndicator.js",
[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}if("function"!==typeof c&&null!==c)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");a(b,c);
b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),k=f.seriesTypes.sma,m=e.correctFloat,q=e.defined,l=e.extend,h=e.isArray,d=e.merge;e=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.averageIndicator=void 0;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(b,a);b.prototype.init=function(){var a=arguments,b=a[1].params;this.averageIndicator=f.seriesTypes[b&&b.average?b.average:void 0]||k;this.averageIndicator.prototype.init.apply(this,a)};b.prototype.calculateDisparityIndex=
function(a,b){return m(a-b)/b*100};b.prototype.getValues=function(a,b){var c=b.index,d=a.xData,e=a.yData,f=e?e.length:0,g=[],k=[],l=[],m=this.averageIndicator,p=h(e[0]);b=m.prototype.getValues(a,b);a=b.yData;b=d.indexOf(b.xData[0]);if(a&&0!==a.length&&q(c)&&!(e.length<=b)){for(m=b;m<f;m++){var v=this.calculateDisparityIndex(p?e[m][c]:e[m],a[m-b]);g.push([d[m],v]);k.push(d[m]);l.push(v)}return{values:g,xData:k,yData:l}}};b.defaultOptions=d(k.defaultOptions,{params:{average:"sma",index:3},marker:{enabled:!1},
dataGrouping:{approximation:"averages"}});return b}(k);l(e.prototype,{nameBase:"Disparity Index",nameComponents:["period","average"]});f.registerSeriesType("disparityindex",e);"";return e});v(f,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map